/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.acl;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.w3c.jigsaw.acl.AclPrincipal;
import org.w3c.jigsaw.acl.DigestAuthPrincipal;
import org.w3c.jigsaw.acl.InvalidAuthException;
import org.w3c.jigsaw.http.Request;
import org.w3c.util.StringUtils;
import org.w3c.www.http.HttpCredential;

public class DigestQopAuthPrincipal
extends DigestAuthPrincipal {
    String dac_opaque = null;
    String dac_cnonce = null;
    String dac_nc = null;
    String dac_qop = null;

    private boolean checkDigest2617(String string, String string2, String string3, String string4) {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append(string).append(':').append(string2);
        stringBuffer.append(':').append(string3);
        String string5 = stringBuffer.toString();
        stringBuffer = new StringBuffer(256);
        stringBuffer.append(this.dac_method).append(':').append(this.dac_uri);
        String string6 = stringBuffer.toString();
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance(this.algo);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return false;
        }
        try {
            messageDigest.update(string5.getBytes("ISO-8859-1"));
            String string7 = StringUtils.toHexString(messageDigest.digest());
            messageDigest.reset();
            messageDigest.update(string6.getBytes("ISO-8859-1"));
            String string8 = StringUtils.toHexString(messageDigest.digest());
            messageDigest.reset();
            stringBuffer = new StringBuffer(256);
            stringBuffer.append(string7).append(':').append(this.dac_nonce).append(':');
            stringBuffer.append(this.dac_nc).append(':').append(this.dac_cnonce).append(':');
            stringBuffer.append(this.dac_qop).append(':').append(string8);
            String string9 = stringBuffer.toString();
            messageDigest.update(string9.getBytes("ISO-8859-1"));
            String string10 = StringUtils.toHexString(messageDigest.digest());
            return string10.equals(this.dac_response);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean equals(Object object) {
        if (this.no_user) {
            return false;
        }
        if (object instanceof AclPrincipal) {
            AclPrincipal aclPrincipal = (AclPrincipal)object;
            String string = aclPrincipal.getName();
            String string2 = aclPrincipal.getRealm();
            String string3 = aclPrincipal.getPassword();
            if (!this.dac_user.equals(string)) {
                return false;
            }
            if (!this.dac_realm.equals(string2)) {
                return false;
            }
            if (this.dac_algorithm != null && !this.dac_algorithm.equals(this.algo)) {
                return false;
            }
            if (!this.dac_nonce.equals(this.nonce)) {
                if (this.dac_nonce.equals(this.old_nonce)) {
                    if (this.checkDigest2617(string, string2, string3, this.old_nonce)) {
                        this.stale = true;
                        return true;
                    }
                } else if (this.checkDigest2617(string, string2, string3, this.dac_nonce)) {
                    System.out.println("** stale!");
                    this.stale = true;
                }
                return false;
            }
            return this.checkDigest2617(string, string2, string3, this.nonce);
        }
        if (object instanceof DigestQopAuthPrincipal) {
            return false;
        }
        return false;
    }

    public DigestQopAuthPrincipal(Request request, String string, String string2, String string3) throws InvalidAuthException {
        super(request, string3);
        HttpCredential httpCredential;
        this.request = request;
        HttpCredential httpCredential2 = httpCredential = request.isProxy() ? request.getProxyAuthorization() : request.getAuthorization();
        if (httpCredential == null || !httpCredential.getScheme().equalsIgnoreCase("Digest")) {
            this.no_user = true;
        } else {
            this.no_user = false;
            this.dac_user = httpCredential.getAuthParameter("username");
            this.dac_uri = httpCredential.getAuthParameter("uri");
            this.dac_response = httpCredential.getAuthParameter("response");
            this.dac_realm = httpCredential.getAuthParameter("realm");
            this.dac_method = request.getMethod();
            this.dac_nonce = httpCredential.getAuthParameter("nonce");
            this.dac_opaque = httpCredential.getAuthParameter("opaque");
            this.dac_cnonce = httpCredential.getAuthParameter("cnonce");
            this.dac_nc = httpCredential.getAuthParameter("nc");
            this.dac_qop = httpCredential.getAuthParameter("qop");
            if (this.dac_qop == null) {
                this.dac_qop = "auth";
            } else if (!this.dac_qop.equals("auth")) {
                String string4 = "qop value not supported";
                throw new InvalidAuthException(string4);
            }
            this.nonce = string;
            this.old_nonce = string2;
            this.algo = string3;
            if (this.dac_user == null || this.dac_uri == null || this.dac_response == null || this.dac_realm == null || this.dac_cnonce == null) {
                String string5 = "Invalid authentication header";
                throw new InvalidAuthException(string5);
            }
        }
    }

    public DigestQopAuthPrincipal(Request request) throws InvalidAuthException {
        super(request);
        throw new InvalidAuthException("Bad call for authentification");
    }
}

