/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.systemProxy;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.javascript.trace.execution.systemProxy.ProxyConfigurator;
import com.intellij.javascript.trace.execution.systemProxy.ProxySettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.math.BigInteger;
import org.jetbrains.annotations.NotNull;

public class WinProxyConfigurator
extends ProxyConfigurator {
    private static final Logger LOG = Logger.getInstance(WinProxyConfigurator.class);
    private static final String PROXY_SETTINGS_REGISTRY_PATH = "HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings\\Connections";
    private static final String PROXY_SETTINGS_REGISTRY_KEY = "DefaultConnectionSettings";

    @Override
    @NotNull
    protected ProxySettings updateSettingsReturnExisting(@NotNull ProxySettings newSettings) throws ExecutionException {
        String proxyData;
        if (newSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newSettings", "com/intellij/javascript/trace/execution/systemProxy/WinProxyConfigurator", "updateSettingsReturnExisting"));
        }
        if (newSettings.isTempSettings()) {
            String proxy = String.format("localhost:%s", newSettings.getPort());
            newSettings.setData("460000000000000003000000" + String.format("%02x", 0xFF & proxy.length()) + "000000" + StringUtil.trimLeading((String)String.format("%040x", new BigInteger(1, proxy.getBytes())), (char)'0') + "0B000000" + StringUtil.trimLeading((String)String.format("%040x", new BigInteger(1, "<-loopback>".getBytes())), (char)'0'));
            LOG.info("Temp proxy settings: " + newSettings.getData());
        }
        ProxySettings existingSettings = new ProxySettings();
        String newProxyData = newSettings.getData();
        ProcessOutput output = ExecUtil.execAndGetOutput((GeneralCommandLine)new GeneralCommandLine(new String[]{"cmd.exe", "/c", "reg", "query", PROXY_SETTINGS_REGISTRY_PATH, "/v", PROXY_SETTINGS_REGISTRY_KEY}));
        String error = output.getStderr();
        if (!error.isEmpty()) {
            LOG.warn(error);
        }
        if (!(proxyData = output.getStdout()).isEmpty()) {
            LOG.info(proxyData);
            existingSettings.setData(proxyData.substring(proxyData.lastIndexOf(" ") + 1).trim());
        } else {
            LOG.warn("Proxy data registry value does not exist");
        }
        if (newProxyData != null && !newProxyData.isEmpty()) {
            output = ExecUtil.execAndGetOutput((GeneralCommandLine)new GeneralCommandLine(new String[]{"cmd.exe", "/c", "reg", "add", PROXY_SETTINGS_REGISTRY_PATH, "/v", PROXY_SETTINGS_REGISTRY_KEY, "/t", "REG_BINARY", "/d", newProxyData, "/f"}));
            error = output.getStderr();
            if (!error.isEmpty()) {
                LOG.warn(error);
            }
            LOG.info(output.getStdout());
        }
        ProxySettings proxySettings = existingSettings;
        if (proxySettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/systemProxy/WinProxyConfigurator", "updateSettingsReturnExisting"));
        }
        return proxySettings;
    }
}

