/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.systemProxy;

import com.intellij.execution.ExecutionException;
import com.intellij.javascript.trace.execution.Utils;
import com.intellij.javascript.trace.execution.systemProxy.LinuxProxyConfigurator;
import com.intellij.javascript.trace.execution.systemProxy.MacProxyConfigurator;
import com.intellij.javascript.trace.execution.systemProxy.ProxySettings;
import com.intellij.javascript.trace.execution.systemProxy.WinProxyConfigurator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public abstract class ProxyConfigurator {
    private static final ProxyConfigurator ourInstance = SystemInfo.isMac ? new MacProxyConfigurator() : (SystemInfo.isWindows ? new WinProxyConfigurator() : (SystemInfo.isLinux ? new LinuxProxyConfigurator() : new ProxyConfigurator(){

        @Override
        @NotNull
        protected ProxySettings updateSettingsReturnExisting(@NotNull ProxySettings newSettings) throws ExecutionException {
            if (newSettings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newSettings", "com/intellij/javascript/trace/execution/systemProxy/ProxyConfigurator$1", "updateSettingsReturnExisting"));
            }
            ProxySettings proxySettings = newSettings;
            if (proxySettings == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/systemProxy/ProxyConfigurator$1", "updateSettingsReturnExisting"));
            }
            return proxySettings;
        }
    }));
    private static final Logger LOG = Logger.getInstance(ProxyConfigurator.class);
    private ProxySettings mySettings;
    private Integer myPort;
    private int startRequestCount = 0;

    public static ProxyConfigurator getInstance() {
        return ourInstance;
    }

    public synchronized void requestStart(int port) {
        if (this.myPort == null) {
            try {
                this.mySettings = this.updateSettingsReturnExisting(new ProxySettings(port));
                this.myPort = port;
            }
            catch (ExecutionException e) {
                LOG.error((Throwable)e);
            }
        }
        if (this.myPort != null && this.myPort == port) {
            ++this.startRequestCount;
        }
    }

    public synchronized void requestStop(int port) {
        if (this.myPort != null && this.myPort == port) {
            --this.startRequestCount;
            if (this.startRequestCount == 0) {
                try {
                    this.updateSettingsReturnExisting(this.mySettings);
                }
                catch (ExecutionException e) {
                    LOG.error((Throwable)e);
                }
                this.myPort = null;
            }
        }
    }

    @NotNull
    protected abstract ProxySettings updateSettingsReturnExisting(@NotNull ProxySettings var1) throws ExecutionException;

    protected String getScriptPath(@NotNull String scriptName) {
        if (scriptName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptName", "com/intellij/javascript/trace/execution/systemProxy/ProxyConfigurator", "getScriptPath"));
        }
        return Utils.getServerScriptPath(scriptName, StringUtil.isEmpty((String)System.getenv("DEBUG_SPY_JS")));
    }
}

