/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.systemProxy;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.javascript.trace.execution.systemProxy.ProxyConfigurator;
import com.intellij.javascript.trace.execution.systemProxy.ProxySettings;
import com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.annotations.NotNull;

public class MacProxyConfigurator
extends ProxyConfigurator {
    private static final Logger LOG = Logger.getInstance(MacProxyConfigurator.class);

    @Override
    @NotNull
    protected ProxySettings updateSettingsReturnExisting(@NotNull ProxySettings newSettings) throws ExecutionException {
        String proxyData;
        if (newSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newSettings", "com/intellij/javascript/trace/execution/systemProxy/MacProxyConfigurator", "updateSettingsReturnExisting"));
        }
        ProcessOutput output = ExecUtil.execAndGetOutput((GeneralCommandLine)new GeneralCommandLine(new String[]{ExecUtil.getOsascriptPath(), "-e", String.format("do shell script \"sh \\\"%s\\\" -autod %s %s %s\"", this.getScriptPath("proxy-osx.sh"), newSettings.isAutoDetectUsed() ? "On" : "Off", newSettings.isAutoConfigUsed() && newSettings.getAutoConfigUrl() != null && !newSettings.getAutoConfigUrl().isEmpty() ? "-autop " + newSettings.getAutoConfigUrl() : "", newSettings.getBypassList() != null && !newSettings.getBypassList().isEmpty() ? "-bypass " + newSettings.getBypassList() : "")}));
        String error = output.getStderr();
        if (!error.isEmpty()) {
            LOG.warn(error);
        }
        if (!(proxyData = output.getStdout()).isEmpty()) {
            String[] values = proxyData.split(";");
            if (values.length == 4) {
                boolean autoDiscovery = values[0] != null && values[0].equals("On");
                boolean autoProxy = values[1] != null && values[1].equals("Yes");
                String autoProxyUrl = values[2] != null && !values[2].equals("(null)") ? values[2] : null;
                String bypassList = values[3] != null && !values[3].isEmpty() ? values[3] : null;
                ProxySettings proxySettings = new ProxySettings(autoDiscovery, autoProxy, autoProxyUrl, bypassList);
                if (proxySettings == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/systemProxy/MacProxyConfigurator", "updateSettingsReturnExisting"));
                }
                return proxySettings;
            }
        } else {
            LOG.warn("Proxy data does not have expected format: " + proxyData);
        }
        ProxySettings proxySettings = new ProxySettings(false, false, null, null);
        if (proxySettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/systemProxy/MacProxyConfigurator", "updateSettingsReturnExisting"));
        }
        return proxySettings;
    }
}

