/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.stack.actions;

import com.intellij.javascript.trace.TraceBundle;
import com.intellij.javascript.trace.execution.Utils;
import com.intellij.javascript.trace.execution.stack.StackNode;
import com.intellij.javascript.trace.execution.stack.StackTree;
import com.intellij.javascript.trace.execution.stack.actions.StackTreeAction;
import com.intellij.javascript.trace.settings.TraceProjectSettings;
import com.intellij.javascript.trace.settings.TraceSettingsManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public class AddFileToFilterAction
extends StackTreeAction {
    @Override
    protected void doUpdate(AnActionEvent e, @NotNull StackTree tree, @NotNull StackNode selectedNode) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/javascript/trace/execution/stack/actions/AddFileToFilterAction", "doUpdate"));
        }
        if (selectedNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedNode", "com/intellij/javascript/trace/execution/stack/actions/AddFileToFilterAction", "doUpdate"));
        }
        TraceProjectSettings.EventFilterState activeFilter = tree.getTraceSettingsManager().getActiveFilter();
        if (activeFilter.matchesFileName(selectedNode.getFile())) {
            e.getPresentation().setVisible(false);
        }
    }

    @Override
    protected void doPerform(AnActionEvent e, @NotNull StackTree tree, @NotNull StackNode selectedNode) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/javascript/trace/execution/stack/actions/AddFileToFilterAction", "doPerform"));
        }
        if (selectedNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedNode", "com/intellij/javascript/trace/execution/stack/actions/AddFileToFilterAction", "doPerform"));
        }
        TraceSettingsManager traceSettingsManager = tree.getTraceSettingsManager();
        String file = selectedNode.getFile();
        TraceProjectSettings.EventFilterConditionState condition = new TraceProjectSettings.EventFilterConditionState();
        condition.setType("file");
        condition.setValue(StringUtil.escapeBackSlashes((String)file));
        traceSettingsManager.addToActiveOrCreateNewFilterAndApply(condition, String.format(TraceBundle.message("console.trace.toolbar.filterEvents.muteNameSuggestionTemplate", new Object[0]), Utils.getShortFileName(file)));
    }
}

