/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.search;

import com.intellij.ide.OccurenceNavigator;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.javascript.trace.TraceBundle;
import com.intellij.javascript.trace.execution.common.TraceContext;
import com.intellij.javascript.trace.execution.common.TraceSession;
import com.intellij.javascript.trace.execution.events.EventNode;
import com.intellij.javascript.trace.execution.events.EventTree;
import com.intellij.javascript.trace.execution.search.TraceSearchRequest;
import com.intellij.javascript.trace.execution.search.TraceSearchResult;
import com.intellij.javascript.trace.execution.stack.StackNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.pom.Navigatable;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TraceSearch
implements OccurenceNavigator {
    private TraceSession myTraceSession;
    private TraceContext myTraceContext;
    private TraceSearchResult mySearchResult;
    private List<EventNode> myFoundEvents;
    private List<StackNode> myFoundFunctions;
    private int myCurrentEventIndex;
    private int myCurrentFunctionIndex;
    private String myFile;
    private Integer myFunctionId;
    private int myTotalOccurenceNumber;
    private int myCurrentOccurenceIndex;
    private boolean mySelectLastFunction;
    private int myCurrentEventNodeFunctionCount;

    public TraceSearch(@NotNull TraceContext traceContext) {
        if (traceContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traceContext", "com/intellij/javascript/trace/execution/search/TraceSearch", "<init>"));
        }
        this.myTraceSession = traceContext.getTraceSession();
        this.myTraceContext = traceContext;
    }

    public boolean hasNextOccurence() {
        return this.hasNextEvent() || this.hasNextFunction();
    }

    public boolean hasPreviousOccurence() {
        return this.hasPrevEvent() || this.hasPrevFunction();
    }

    public OccurenceNavigator.OccurenceInfo goNextOccurence() {
        ++this.myCurrentOccurenceIndex;
        return new OccurenceNavigator.OccurenceInfo(new Navigatable(){

            public void navigate(boolean requestFocus) {
                TraceSearch.this.moveNext();
            }

            public boolean canNavigate() {
                return true;
            }

            public boolean canNavigateToSource() {
                return false;
            }
        }, this.myCurrentOccurenceIndex, this.myTotalOccurenceNumber);
    }

    public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
        --this.myCurrentOccurenceIndex;
        return new OccurenceNavigator.OccurenceInfo(new Navigatable(){

            public void navigate(boolean requestFocus) {
                TraceSearch.this.movePrev();
            }

            public boolean canNavigate() {
                return true;
            }

            public boolean canNavigateToSource() {
                return false;
            }
        }, this.myCurrentOccurenceIndex, this.myTotalOccurenceNumber);
    }

    public String getNextOccurenceActionName() {
        return TraceBundle.message("console.stack.toolbar.nextTraceSearch", new Object[0]);
    }

    public String getPreviousOccurenceActionName() {
        return TraceBundle.message("console.stack.toolbar.prevTraceSearch", new Object[0]);
    }

    public void searchFunction(@NotNull String file, int functionId) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/trace/execution/search/TraceSearch", "searchFunction"));
        }
        UsageTrigger.trigger((String)TraceBundle.message("usage.search", new Object[0]));
        this.reset();
        this.myFile = file;
        this.myFunctionId = functionId;
        this.myTraceSession.searchFunction(new TraceSearchRequest(file, functionId), (Consumer<TraceSearchResult>)((Consumer)result -> {
            if (result.isEmpty()) {
                this.reset();
                this.reportFunctionNotFound();
                return;
            }
            EventTree eventTree = this.myTraceContext.getCurrentEventTree();
            if (eventTree == null) {
                return;
            }
            this.mySearchResult = result;
            this.myCurrentOccurenceIndex = 1;
            this.myTotalOccurenceNumber = this.mySearchResult.getTotal();
            this.myFoundEvents = ContainerUtil.filter((Object[])eventTree.getAllEventNodesOrderedByOccurenceTimeDesc(), node -> this.mySearchResult.contains(node.getEvent().getStreamId(), node.getEventId()));
            if (this.myFoundEvents.isEmpty()) {
                this.reset();
                this.reportExpectedTotalMismatch();
            } else {
                this.reportNumberOfFunctionCallsFound();
                ApplicationManager.getApplication().invokeLater(() -> this.moveToEvent(0));
            }
        }));
    }

    private boolean hasNextEvent() {
        return this.hasValidSearchResult() && this.myCurrentEventIndex < this.myFoundEvents.size() - 1;
    }

    private boolean hasPrevEvent() {
        return this.hasValidSearchResult() && this.myCurrentEventIndex > 0;
    }

    private boolean hasNextFunction() {
        return this.hasValidSearchResult() && this.myFoundFunctions != null && !this.myFoundFunctions.isEmpty() && this.myCurrentFunctionIndex < this.myFoundFunctions.size() - 1;
    }

    private boolean hasPrevFunction() {
        return this.hasValidSearchResult() && this.myCurrentFunctionIndex > 0;
    }

    private void moveToNextEvent() {
        if (!this.hasNextEvent()) {
            return;
        }
        this.moveToEvent(this.myCurrentEventIndex + 1);
        this.mySelectLastFunction = false;
    }

    private void moveToPrevEvent() {
        if (!this.hasPrevEvent()) {
            return;
        }
        this.moveToEvent(this.myCurrentEventIndex - 1);
        this.mySelectLastFunction = true;
    }

    private void moveToNextFunction() {
        if (!this.hasNextFunction()) {
            return;
        }
        this.moveToFunction(this.myCurrentFunctionIndex + 1);
    }

    private void moveToPrevFunction() {
        if (!this.hasPrevFunction()) {
            return;
        }
        this.moveToFunction(this.myCurrentFunctionIndex - 1);
    }

    private void moveNext() {
        if (!this.hasNextOccurence()) {
            return;
        }
        if (this.hasNextFunction()) {
            this.moveToNextFunction();
        } else {
            this.moveToNextEvent();
        }
    }

    private void movePrev() {
        if (!this.hasPreviousOccurence()) {
            return;
        }
        if (this.hasPrevFunction()) {
            this.moveToPrevFunction();
        } else {
            this.moveToPrevEvent();
        }
    }

    private void moveToEvent(int index) {
        this.myCurrentEventIndex = index;
        EventNode eventNode = this.myFoundEvents.get(this.myCurrentEventIndex);
        this.myTraceContext.select(eventNode, (Function<StackNode[], StackNode>)((Function)stackNodes -> {
            if (!this.hasValidSearchResult()) {
                return null;
            }
            this.myCurrentEventNodeFunctionCount = ((StackNode[])stackNodes).length;
            if (((StackNode[])stackNodes).length == 0) {
                this.handleNoFoundFunctions();
                return null;
            }
            if (stackNodes[0].getScope().getEventMetadata().getEventId() != eventNode.getEventId()) {
                this.reset();
                return null;
            }
            this.myFoundFunctions = ContainerUtil.filter((Object[])stackNodes, node -> node.getFile().equals(this.myFile) && node.getFunctionId() == this.myFunctionId.intValue());
            if (!this.myFoundFunctions.isEmpty()) {
                if (this.myCurrentOccurenceIndex < this.myTotalOccurenceNumber && !this.hasNextOccurence() || this.myTotalOccurenceNumber == -1) {
                    this.handleExpectedTotalMismatch();
                }
                int functionIndex = this.mySelectLastFunction ? this.myFoundFunctions.size() - 1 : 0;
                return this.moveToFunction(functionIndex);
            }
            this.handleNoFoundFunctions();
            return null;
        }));
    }

    private void handleNoFoundFunctions() {
        this.myFoundFunctions = new ArrayList<StackNode>();
        this.myTotalOccurenceNumber = -1;
        this.myCurrentFunctionIndex = 0;
        this.reportFunctionExpectedButNotFound();
        this.keepMoving();
    }

    private void handleExpectedTotalMismatch() {
        this.myTotalOccurenceNumber = -1;
        this.reportExpectedTotalMismatch();
    }

    private void reportNumberOfFunctionCallsFound() {
        StatusBar.Info.set((String)String.format(TraceBundle.message("status.search.totalFunctionCallsTemplate", new Object[0]), this.myTotalOccurenceNumber), (Project)this.myTraceContext.getProject());
    }

    private void reportFunctionNotFound() {
        StatusBar.Info.set((String)TraceBundle.message("status.search.functionNotFound", new Object[0]), (Project)this.myTraceContext.getProject());
    }

    private void reportFunctionExpectedButNotFound() {
        StatusBar.Info.set((String)TraceBundle.message("status.search.functionExpectedButNotFound", new Object[0]), (Project)this.myTraceContext.getProject());
    }

    private void reportExpectedTotalMismatch() {
        StatusBar.Info.set((String)TraceBundle.message("status.search.expectedTotalMismatch", new Object[0]), (Project)this.myTraceContext.getProject());
    }

    private void keepMoving() {
        if (this.mySelectLastFunction) {
            this.moveToPrevEvent();
        } else {
            this.moveToNextEvent();
        }
    }

    private StackNode moveToFunction(int index) {
        this.myCurrentFunctionIndex = index;
        StackNode stackNode = this.myFoundFunctions.get(this.myCurrentFunctionIndex);
        this.myTraceContext.select(this.myFoundEvents.get(this.myCurrentEventIndex), (Function<StackNode[], StackNode>)((Function)nodes -> {
            if (this.myCurrentEventNodeFunctionCount != ((StackNode[])nodes).length) {
                this.handleNoFoundFunctions();
                return null;
            }
            if (this.myTotalOccurenceNumber == -1) {
                this.reportExpectedTotalMismatch();
            }
            return stackNode;
        }));
        return stackNode;
    }

    public void reset() {
        this.mySearchResult = null;
        this.myFoundEvents = null;
        this.myFoundFunctions = new ArrayList<StackNode>();
        this.myCurrentEventIndex = 0;
        this.myCurrentEventNodeFunctionCount = 0;
        this.myCurrentFunctionIndex = 0;
        this.myTotalOccurenceNumber = -1;
        this.myCurrentOccurenceIndex = -1;
        this.mySelectLastFunction = false;
    }

    private boolean hasValidSearchResult() {
        return this.myTraceSession.isRunning() && this.mySearchResult != null && this.myFoundEvents != null && !this.myFoundEvents.isEmpty();
    }

    public void moveToLastOccurence() {
        this.mySelectLastFunction = true;
        this.myCurrentOccurenceIndex = this.myTotalOccurenceNumber;
        this.moveToEvent(this.myFoundEvents.size() - 1);
    }

    public void moveToFirstOccurence() {
        this.mySelectLastFunction = false;
        this.myCurrentFunctionIndex = 0;
        this.myCurrentOccurenceIndex = 1;
        this.moveToEvent(0);
    }

    public boolean isActive() {
        return this.mySearchResult != null;
    }
}

