/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.common;

import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertyMetadata {
    private final String myNormalizedName;
    private String myName;
    @Nullable
    private String myParams;
    private int myLength;
    private boolean myIsEmpty;
    private int[] myRanges;
    private String myValue;
    private String[] myContext;
    private String myType;

    public PropertyMetadata(@NotNull String name, @NotNull String type, @Nullable String params, @Nullable String value, int length, boolean isEmpty, @NotNull int[] ranges, @NotNull String[] context) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/javascript/trace/execution/common/PropertyMetadata", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/javascript/trace/execution/common/PropertyMetadata", "<init>"));
        }
        if (ranges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/intellij/javascript/trace/execution/common/PropertyMetadata", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/trace/execution/common/PropertyMetadata", "<init>"));
        }
        this.myName = name.equals("this") ? "['this']" : name;
        this.myNormalizedName = StringUtil.trimEnd((String)StringUtil.trimStart((String)name, (String)"['"), (String)"']");
        this.myParams = params;
        this.myLength = length;
        this.myIsEmpty = isEmpty;
        this.myRanges = ranges;
        this.myValue = StringUtil.notNullize((String)value);
        this.myContext = context;
        this.myType = StringUtil.capitalize((String)type);
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/common/PropertyMetadata", "getName"));
        }
        return string;
    }

    @NotNull
    public String getNormalizedName() {
        String string = this.myNormalizedName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/common/PropertyMetadata", "getNormalizedName"));
        }
        return string;
    }

    @NotNull
    public String getType() {
        String string = this.myType;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/common/PropertyMetadata", "getType"));
        }
        return string;
    }

    @NotNull
    public String[] getContext() {
        if (this.myContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/common/PropertyMetadata", "getContext"));
        }
        return this.myContext;
    }

    @Nullable
    public String getParams() {
        return this.myParams;
    }

    @NotNull
    public String getPrimitiveValue() {
        String string = this.myValue;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/common/PropertyMetadata", "getPrimitiveValue"));
        }
        return string;
    }

    public int getLength() {
        return this.myLength;
    }

    public static PropertyMetadata create(@NotNull String name, @NotNull String type, @NotNull String params) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/javascript/trace/execution/common/PropertyMetadata", "create"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/javascript/trace/execution/common/PropertyMetadata", "create"));
        }
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/javascript/trace/execution/common/PropertyMetadata", "create"));
        }
        return new PropertyMetadata(name, type, params, null, 0, true, new int[0], new String[0]);
    }

    public boolean isEmpty() {
        return this.myIsEmpty;
    }

    public int[] getRanges() {
        return this.myRanges;
    }
}

