/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.common;

import com.intellij.javascript.trace.execution.code.CodeElement;
import com.intellij.javascript.trace.execution.code.MappedCodePosition;
import com.intellij.javascript.trace.execution.code.StaticCodeElement;
import com.intellij.javascript.trace.execution.common.MappedTraceVirtualFile;
import com.intellij.javascript.trace.execution.common.RuntimeFunctionArgument;
import com.intellij.javascript.trace.execution.common.RuntimeFunctionScope;
import com.intellij.javascript.trace.execution.common.RuntimeReturnStatement;
import com.intellij.javascript.trace.execution.common.RuntimeStatement;
import com.intellij.javascript.trace.execution.common.TraceVirtualFile;
import com.intellij.javascript.trace.execution.context.StackFrameContext;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class OriginalTraceVirtualFile
extends TraceVirtualFile {
    private final MappedTraceVirtualFile[] myMappedTraceVirtualFiles;

    public OriginalTraceVirtualFile(String url, String content, VirtualFile localFile, MappedTraceVirtualFile[] mappedTraceVirtualFiles, String streamId) {
        super(url, content, localFile, streamId);
        this.setFileType((FileType)JavaScriptFileType.INSTANCE);
        this.setLanguage((Language)JavascriptLanguage.INSTANCE);
        this.myMappedTraceVirtualFiles = mappedTraceVirtualFiles;
    }

    @NotNull
    public TraceVirtualFile getFileToDisplay(@NotNull StackFrameContext context, boolean useMappedSourceIfAvailable) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/trace/execution/common/OriginalTraceVirtualFile", "getFileToDisplay"));
        }
        TraceVirtualFile activeFile = this;
        if (!useMappedSourceIfAvailable) {
            OriginalTraceVirtualFile originalTraceVirtualFile = activeFile;
            if (originalTraceVirtualFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/common/OriginalTraceVirtualFile", "getFileToDisplay"));
            }
            return originalTraceVirtualFile;
        }
        boolean manyOrWrongMappedFiles = false;
        for (RuntimeStatement runtimeStatement : context.getStackFrame().getStatements()) {
            MappedCodePosition mappedCodePosition = runtimeStatement.getCodeRange().getMappedCodePosition();
            if (mappedCodePosition == null) continue;
            if (mappedCodePosition.getMappedFileIndex() >= this.myMappedTraceVirtualFiles.length) {
                manyOrWrongMappedFiles = true;
                break;
            }
            MappedTraceVirtualFile mappedTraceVirtualFile = this.myMappedTraceVirtualFiles[mappedCodePosition.getMappedFileIndex()];
            if (StringUtil.isEmpty((CharSequence)mappedTraceVirtualFile.getContent())) {
                mappedCodePosition.setInvalid();
                continue;
            }
            if (activeFile != this && !((Object)((Object)mappedTraceVirtualFile)).equals((Object)activeFile)) {
                manyOrWrongMappedFiles = true;
                break;
            }
            activeFile = mappedTraceVirtualFile;
        }
        if (manyOrWrongMappedFiles) {
            activeFile = this;
        }
        OriginalTraceVirtualFile originalTraceVirtualFile = activeFile;
        if (originalTraceVirtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/common/OriginalTraceVirtualFile", "getFileToDisplay"));
        }
        return originalTraceVirtualFile;
    }

    @Override
    @NotNull
    public TextRange getFunctionRange(@NotNull Editor editor, @NotNull RuntimeFunctionScope functionScope) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/javascript/trace/execution/common/OriginalTraceVirtualFile", "getFunctionRange"));
        }
        if (functionScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionScope", "com/intellij/javascript/trace/execution/common/OriginalTraceVirtualFile", "getFunctionRange"));
        }
        TextRange textRange = OriginalTraceVirtualFile.getCodeElementRange(editor, functionScope);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/common/OriginalTraceVirtualFile", "getFunctionRange"));
        }
        return textRange;
    }

    @Override
    @NotNull
    public TextRange getStatementRange(@NotNull Editor editor, @NotNull RuntimeFunctionScope functionScope, @NotNull StaticCodeElement statement) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/javascript/trace/execution/common/OriginalTraceVirtualFile", "getStatementRange"));
        }
        if (functionScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionScope", "com/intellij/javascript/trace/execution/common/OriginalTraceVirtualFile", "getStatementRange"));
        }
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/javascript/trace/execution/common/OriginalTraceVirtualFile", "getStatementRange"));
        }
        TextRange textRange = OriginalTraceVirtualFile.getCodeElementRange(editor, statement);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/common/OriginalTraceVirtualFile", "getStatementRange"));
        }
        return textRange;
    }

    @Override
    @NotNull
    public TextRange getReturnStatementRange(@NotNull Editor editor, @NotNull RuntimeReturnStatement returnStatement) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/javascript/trace/execution/common/OriginalTraceVirtualFile", "getReturnStatementRange"));
        }
        if (returnStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnStatement", "com/intellij/javascript/trace/execution/common/OriginalTraceVirtualFile", "getReturnStatementRange"));
        }
        TextRange textRange = OriginalTraceVirtualFile.getCodeElementRange(editor, returnStatement);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/common/OriginalTraceVirtualFile", "getReturnStatementRange"));
        }
        return textRange;
    }

    @Override
    @NotNull
    public TextRange getParamRange(@NotNull Editor editor, @NotNull RuntimeFunctionArgument argument) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/javascript/trace/execution/common/OriginalTraceVirtualFile", "getParamRange"));
        }
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "com/intellij/javascript/trace/execution/common/OriginalTraceVirtualFile", "getParamRange"));
        }
        TextRange textRange = OriginalTraceVirtualFile.getCodeElementRange(editor, argument);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/common/OriginalTraceVirtualFile", "getParamRange"));
        }
        return textRange;
    }

    @NotNull
    private static TextRange getCodeElementRange(@NotNull Editor editor, @NotNull CodeElement element) {
        TextRange textRange;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/javascript/trace/execution/common/OriginalTraceVirtualFile", "getCodeElementRange"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/trace/execution/common/OriginalTraceVirtualFile", "getCodeElementRange"));
        }
        Document document = editor.getDocument();
        try {
            textRange = element.getCodeRange().convertToTextRange(document);
        }
        catch (Exception ex) {
            TextRange textRange2 = TextRange.EMPTY_RANGE;
            if (textRange2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/common/OriginalTraceVirtualFile", "getCodeElementRange"));
            }
            return textRange2;
        }
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/common/OriginalTraceVirtualFile", "getCodeElementRange"));
        }
        return textRange;
    }
}

