/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.common;

import com.intellij.javascript.trace.execution.common.EventMetadata;
import com.intellij.javascript.trace.execution.common.StackEntry;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import org.jetbrains.annotations.NotNull;

public class EventMetadataExtended
extends EventMetadata {
    private HashSet<String> myFiles;
    private HashSet<String> myFileIds;
    private StackEntry myFirstEntry;
    private StackEntry myLastEntry;
    private boolean myIsGlobalScope;
    private String myGlobalScopeFile;

    /*
     * WARNING - void declaration
     */
    public EventMetadataExtended(@NotNull String streamId, long eventId, String globalScopeFile, @NotNull String[] files, @NotNull String[] fileIds, @NotNull StackEntry firstEntry, @NotNull StackEntry stackEntry) {
        void lastEntry;
        if (streamId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "streamId", "com/intellij/javascript/trace/execution/common/EventMetadataExtended", "<init>"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/javascript/trace/execution/common/EventMetadataExtended", "<init>"));
        }
        if (fileIds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileIds", "com/intellij/javascript/trace/execution/common/EventMetadataExtended", "<init>"));
        }
        if (firstEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "firstEntry", "com/intellij/javascript/trace/execution/common/EventMetadataExtended", "<init>"));
        }
        if (stackEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lastEntry", "com/intellij/javascript/trace/execution/common/EventMetadataExtended", "<init>"));
        }
        super(streamId, eventId);
        this.myFiles = new HashSet();
        this.myFileIds = new HashSet();
        this.myGlobalScopeFile = globalScopeFile;
        this.myIsGlobalScope = globalScopeFile != null && !globalScopeFile.isEmpty();
        ContainerUtil.addAll(this.myFiles, (Object[])files);
        ContainerUtil.addAll(this.myFileIds, (Object[])fileIds);
        this.myFirstEntry = firstEntry;
        this.myLastEntry = lastEntry;
    }

    public String[] getFiles() {
        return (String[])this.myFiles.toArray((Object[])new String[this.myFiles.size()]);
    }

    public String[] getFileIds() {
        return (String[])this.myFileIds.toArray((Object[])new String[this.myFileIds.size()]);
    }

    public void addFiles(String[] files, String[] fileIds) {
        ContainerUtil.addAll(this.myFiles, (Object[])files);
        ContainerUtil.addAll(this.myFileIds, (Object[])fileIds);
    }

    public StackEntry getFirstEntry() {
        return this.myFirstEntry;
    }

    public void setLastEntry(StackEntry lastEntry) {
        this.myLastEntry = lastEntry;
    }

    public StackEntry getLastEntry() {
        return this.myLastEntry;
    }

    public boolean isGlobalScope() {
        return this.myIsGlobalScope;
    }

    public String getGlobalScopeFile() {
        return this.myGlobalScopeFile;
    }
}

