/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution;

import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.javascript.trace.TraceBundle;
import com.intellij.openapi.project.Project;
import com.intellij.util.config.Storage;
import org.jetbrains.annotations.NotNull;

public class TraceConsoleProperties {
    private static final String AUTO_SCROLL_TO_TRACE = "autoScrollToTrace";
    private static final String EVENT_FILTER = "eventFilterName";
    private static final String CLOSE_TRACE_ON_SESSION_STOP = "closeTraceFilesOnSessionStop";
    private static final String CLOSE_DIAGRAMS_ON_SESSION_STOP = "closeDiagramFilesOnSessionStop";
    private static final String REALTIME_EVALUATION = "enableRealtimeEvaluation";
    private static final String ALWAYS_OPEN_MAPPED_TRACE = "alwaysOpenMappedTrace";
    private static final String SOURCE_MAPS_LOOKUP = "enableSourceMapLookupSupport";
    private static final String SOURCE_MAPS_GENERATION = "enableSourceMapGenerationSupport";
    private final Storage.PropertiesComponentStorage myStorage;
    private Project myProject;
    private RunConfiguration myConfig;

    public TraceConsoleProperties(@NotNull Project project, @NotNull RunConfiguration config) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/trace/execution/TraceConsoleProperties", "<init>"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/javascript/trace/execution/TraceConsoleProperties", "<init>"));
        }
        this.myStorage = new Storage.PropertiesComponentStorage(TraceBundle.message("console.trace.propertiesStoragePrefix", new Object[0]), PropertiesComponent.getInstance());
        this.myProject = project;
        this.myConfig = config;
    }

    public RunConfiguration getConfiguration() {
        return this.myConfig;
    }

    public Project getProject() {
        return this.myProject;
    }

    public String getEventFilterName() {
        return this.myStorage.get(EVENT_FILTER);
    }

    public void setEventFilterName(String name) {
        this.myStorage.put(EVENT_FILTER, name);
    }

    public boolean getAutoScrollToTrace() {
        return Boolean.parseBoolean(this.myStorage.get(AUTO_SCROLL_TO_TRACE));
    }

    public void setAutoScrollToTrace(boolean value) {
        this.myStorage.put(AUTO_SCROLL_TO_TRACE, String.valueOf(value));
    }

    public boolean needToCloseTraceFilesOnSessionStop() {
        return Boolean.parseBoolean(this.myStorage.get(CLOSE_TRACE_ON_SESSION_STOP));
    }

    public void setCloseTraceFilesOnSessionStop(boolean value) {
        this.myStorage.put(CLOSE_TRACE_ON_SESSION_STOP, String.valueOf(value));
    }

    public boolean needToCloseDiagramFilesOnSessionStop() {
        return Boolean.parseBoolean(this.myStorage.get(CLOSE_DIAGRAMS_ON_SESSION_STOP));
    }

    public void setCloseDiagramFilesOnSessionStop(boolean value) {
        this.myStorage.put(CLOSE_DIAGRAMS_ON_SESSION_STOP, String.valueOf(value));
    }

    public boolean isRealtimeEvaluationEnabled() {
        return Boolean.parseBoolean(this.myStorage.get(REALTIME_EVALUATION));
    }

    public void setRealtimeEvaluationEnabled(boolean value) {
        this.myStorage.put(REALTIME_EVALUATION, String.valueOf(value));
    }

    public boolean alwaysOpenMappedTraceIfAvailable() {
        return Boolean.parseBoolean(this.myStorage.get(ALWAYS_OPEN_MAPPED_TRACE));
    }

    public void setAlwaysOpenMappedTraceIfAvailable(boolean value) {
        this.myStorage.put(ALWAYS_OPEN_MAPPED_TRACE, String.valueOf(value));
    }

    public boolean isSourceMapLookupEnabled() {
        return Boolean.parseBoolean(this.myStorage.get(SOURCE_MAPS_LOOKUP));
    }

    public void setSourceMapLookupEnabled(boolean value) {
        this.myStorage.put(SOURCE_MAPS_LOOKUP, String.valueOf(value));
    }

    public void setSourceMapGenerationEnabled(boolean value) {
        this.myStorage.put(SOURCE_MAPS_GENERATION, String.valueOf(value));
    }

    public boolean isSourceMapGenerationEnabled() {
        return Boolean.parseBoolean(this.myStorage.get(SOURCE_MAPS_GENERATION));
    }
}

