/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.editor;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.execution.testframework.ui.SameHeightPanel;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.javascript.trace.TraceBundle;
import com.intellij.javascript.trace.execution.common.TraceContext;
import com.intellij.javascript.trace.execution.fileDependency.FileDependencyDetailsPanel;
import com.intellij.javascript.trace.execution.fileDependency.FileDependencyGraph;
import com.intellij.javascript.trace.execution.fileDependency.FileDependencyGraphPresentation;
import com.intellij.javascript.trace.execution.fileDependency.FileDependencyVirtualFile;
import com.intellij.javascript.trace.execution.fileDependency.FileNode;
import com.intellij.javascript.trace.execution.fileDependency.RuntimeDependencyEdge;
import com.intellij.javascript.trace.settings.TraceProjectSettings;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.NavigatableFileEditor;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.base.Graph;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.GraphBuilderFactory;
import com.intellij.openapi.graph.builder.GraphDataModel;
import com.intellij.openapi.graph.builder.GraphPresentationModel;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.pom.Navigatable;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.Consumer;
import com.intellij.util.containers.Predicate;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileDependencyGraphViewer
extends UserDataHolderBase
implements NavigatableFileEditor,
DataProvider {
    private final JPanel myMainPanel;
    private JComponent myGraphComponent;
    private GraphBuilder<FileNode, RuntimeDependencyEdge> myBuilder;
    private Project myProject;
    private final FileDependencyVirtualFile myFile;

    public FileDependencyGraphViewer(@NotNull Project project, @NotNull FileDependencyVirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/trace/editor/FileDependencyGraphViewer", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/trace/editor/FileDependencyGraphViewer", "<init>"));
        }
        this.myProject = project;
        UsageTrigger.trigger((String)TraceBundle.message("usage.diagram.viewer.display", new Object[0]));
        this.myFile = file;
        this.myMainPanel = new JPanel(new BorderLayout());
        this.renderGraph();
    }

    private void renderGraph() {
        FileDependencyGraph dependencyGraph = this.myFile.getFileDependencyGraph();
        TraceContext traceContext = this.myFile.getTraceContext();
        final TraceProjectSettings.EventFilterState activeFilter = traceContext.getTraceSettingsManager().getActiveFilter();
        dependencyGraph.addNodeFilter(new Predicate<FileNode>(){

            public boolean apply(@Nullable FileNode input) {
                return input != null && !activeFilter.matchesFileName(input.getUrl());
            }
        });
        boolean isEmptyGraph = dependencyGraph.getEdges().isEmpty();
        if (isEmptyGraph) {
            JPanel panel = new JPanel(new GridBagLayout());
            JLabel label = new JLabel(traceContext.getTraceSession().isRunning() ? TraceBundle.message("fileDependency.emptyGraph.message", new Object[0]) : TraceBundle.message("fileDependency.sessionStopped.message", new Object[0]));
            label.setBorder((Border)JBUI.Borders.empty((int)0, (int)25));
            panel.add((Component)label, new GridBagConstraints());
            this.myMainPanel.add((Component)panel, "Center");
        } else {
            JPanel rightPanel = new JPanel(new BorderLayout());
            JPanel leftPanel = new JPanel(new BorderLayout());
            JPanel graphPanel = new JPanel(new BorderLayout());
            JPanel graphToolbar = new JPanel(new BorderLayout());
            JPanel detailsToolbar = new JPanel(new BorderLayout());
            FileDependencyDetailsPanel detailsPanel = new FileDependencyDetailsPanel(traceContext, rightPanel, detailsToolbar);
            detailsPanel.setBorder(IdeBorderFactory.createBorder((int)3));
            Consumer nodeSelectedConsumer = node -> detailsPanel.displayNodeDetails(dependencyGraph.getStreamId(), (FileNode)node);
            Consumer edgeSelectedConsumer = edge -> detailsPanel.displayEdgeDetails(dependencyGraph.getStreamId(), (RuntimeDependencyEdge)edge);
            Graph2D graph2D = GraphManager.getGraphManager().createGraph2D();
            Graph2DView view = GraphManager.getGraphManager().createGraph2DView();
            GraphViewUtil.addDataProvider((Graph2DView)view, (DataProvider)this);
            FileDependencyGraphPresentation presentation = new FileDependencyGraphPresentation((Graph)graph2D, (Consumer<FileNode>)nodeSelectedConsumer, (Consumer<RuntimeDependencyEdge>)edgeSelectedConsumer);
            this.myBuilder = GraphBuilderFactory.getInstance((Project)this.myProject).createGraphBuilder(graph2D, view, (GraphDataModel)dependencyGraph, (GraphPresentationModel)presentation);
            this.myGraphComponent = (JComponent)this.myBuilder.getView().getComponent();
            graphPanel.add((Component)this.myGraphComponent, "Center");
            graphPanel.setBorder(IdeBorderFactory.createBorder((int)6));
            this.myBuilder.initialize();
            ActionManager actionManager = ActionManager.getInstance();
            graphToolbar.add((Component)actionManager.createActionToolbar("unknown", (ActionGroup)FileDependencyGraphViewer.getGraphToolbarActionGroup(), true).getComponent(), "Center");
            leftPanel.add((Component)graphPanel, "Center");
            leftPanel.add((Component)graphToolbar, "North");
            rightPanel.add((Component)detailsPanel, "Center");
            rightPanel.add((Component)SameHeightPanel.wrap((JComponent)detailsToolbar, (JComponent)graphToolbar), "North");
            Splitter splitter = new Splitter();
            splitter.setFirstComponent((JComponent)leftPanel);
            splitter.setSecondComponent((JComponent)rightPanel);
            splitter.setHonorComponentsMinimumSize(false);
            splitter.setProportion(0.8f);
            this.myMainPanel.add((Component)splitter, "Center");
        }
    }

    public static DefaultActionGroup getGraphToolbarActionGroup() {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add(ActionManager.getInstance().getAction("Spy-js.FileDependencyGraph.Default"));
        return actionGroup;
    }

    public boolean canNavigateTo(@NotNull Navigatable navigatable) {
        if (navigatable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigatable", "com/intellij/javascript/trace/editor/FileDependencyGraphViewer", "canNavigateTo"));
        }
        return false;
    }

    public void navigateTo(@NotNull Navigatable navigatable) {
        if (navigatable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigatable", "com/intellij/javascript/trace/editor/FileDependencyGraphViewer", "navigateTo"));
        }
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/editor/FileDependencyGraphViewer", "getComponent"));
        }
        return jPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myGraphComponent;
    }

    @NotNull
    public String getName() {
        String string = this.myFile.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/editor/FileDependencyGraphViewer", "getName"));
        }
        return string;
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/javascript/trace/editor/FileDependencyGraphViewer", "getState"));
        }
        FileEditorState fileEditorState = new FileEditorState(){

            public boolean canBeMergedWith(FileEditorState otherState, FileEditorStateLevel level) {
                return false;
            }
        };
        if (fileEditorState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/editor/FileDependencyGraphViewer", "getState"));
        }
        return fileEditorState;
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/javascript/trace/editor/FileDependencyGraphViewer", "setState"));
        }
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void selectNotify() {
        if (this.myFile.hasChanged()) {
            this.myFile.setUpdated();
            if (this.myBuilder != null) {
                Disposer.dispose(this.myBuilder);
            }
            this.myMainPanel.removeAll();
            this.renderGraph();
        }
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/javascript/trace/editor/FileDependencyGraphViewer", "addPropertyChangeListener"));
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/javascript/trace/editor/FileDependencyGraphViewer", "removePropertyChangeListener"));
        }
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    public void dispose() {
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myBuilder.getProject();
        }
        if (PlatformDataKeys.FILE_EDITOR.is(dataId)) {
            return this;
        }
        if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
            return this.myFile;
        }
        return null;
    }
}

