/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vaadin.templates;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class VaadinTemplateNames {
    private String myApplication;
    private String myWidget;
    private ClientWidgetClassTemplate[] myClientWidgets;
    private String myCustomComponent;
    private String myWidgetSetModule;

    public VaadinTemplateNames(@NotNull String application, @NotNull String customComponent, @NotNull String widgetSetModule, String widget, ClientWidgetClassTemplate ... clientWidgets) {
        if (application == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "application", "com/intellij/vaadin/templates/VaadinTemplateNames", "<init>"));
        }
        if (customComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "customComponent", "com/intellij/vaadin/templates/VaadinTemplateNames", "<init>"));
        }
        if (widgetSetModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "widgetSetModule", "com/intellij/vaadin/templates/VaadinTemplateNames", "<init>"));
        }
        this.myApplication = application;
        this.myWidget = widget;
        this.myClientWidgets = clientWidgets;
        this.myCustomComponent = customComponent;
        this.myWidgetSetModule = widgetSetModule;
    }

    public String getApplication() {
        return this.myApplication;
    }

    public String getWidget() {
        return this.myWidget;
    }

    public ClientWidgetClassTemplate[] getClientWidgetClasses() {
        return this.myClientWidgets;
    }

    public String getCustomComponent() {
        return this.myCustomComponent;
    }

    public String getWidgetSetModule() {
        return this.myWidgetSetModule;
    }

    public List<String> getAllTemplates() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.myApplication);
        result.add(this.myWidget);
        for (ClientWidgetClassTemplate widget : this.myClientWidgets) {
            result.add(widget.getTemplateName());
        }
        result.add(this.myCustomComponent);
        result.add(this.myWidgetSetModule);
        return result;
    }

    public static class ClientWidgetClassTemplate {
        private final String myNameSuffix;
        private final String myTemplateName;

        private ClientWidgetClassTemplate(String nameSuffix, String templateName) {
            this.myNameSuffix = nameSuffix;
            this.myTemplateName = templateName;
        }

        public static ClientWidgetClassTemplate clientWidget(@NotNull String nameSuffix, @NotNull String templateName) {
            if (nameSuffix == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameSuffix", "com/intellij/vaadin/templates/VaadinTemplateNames$ClientWidgetClassTemplate", "clientWidget"));
            }
            if (templateName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateName", "com/intellij/vaadin/templates/VaadinTemplateNames$ClientWidgetClassTemplate", "clientWidget"));
            }
            return new ClientWidgetClassTemplate(nameSuffix, templateName);
        }

        public String getNameSuffix() {
            return this.myNameSuffix;
        }

        public String getTemplateName() {
            return this.myTemplateName;
        }
    }
}

