/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vaadin.actions;

import com.intellij.ide.actions.CreateElementActionBase;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiUtil;
import com.intellij.vaadin.actions.VaadinCreateElementActionBase;
import com.intellij.vaadin.framework.VaadinVersion;
import com.intellij.vaadin.framework.VaadinVersionUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class CreateCustomComponentAction
extends VaadinCreateElementActionBase {
    public CreateCustomComponentAction() {
        super("Vaadin Custom Component", "Create new Vaadin custom component");
    }

    @NotNull
    protected PsiElement[] create(String newName, PsiDirectory directory) throws Exception {
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)directory.getVirtualFile(), (Project)directory.getProject());
        if (module == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vaadin/actions/CreateCustomComponentAction", "create"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiUtil.checkIsIdentifier((PsiManager)directory.getManager(), (String)newName);
        VaadinVersion version = VaadinVersionUtil.getVaadinVersion(module);
        PsiClass aClass = JavaDirectoryService.getInstance().createClass(directory, newName, version.getTemplateNames().getCustomComponent());
        PsiElement[] psiElementArray = new PsiElement[]{aClass};
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vaadin/actions/CreateCustomComponentAction", "create"));
        }
        return psiElementArray;
    }

    @NotNull
    protected PsiElement[] invokeDialog(Project project, PsiDirectory directory) {
        CreateElementActionBase.MyInputValidator validator = new CreateElementActionBase.MyInputValidator((CreateElementActionBase)this, project, directory);
        Messages.showInputDialog((Project)project, (String)"Enter a new class name:", (String)"New Vaadin Custom Component", (Icon)Messages.getQuestionIcon(), (String)"", (InputValidator)validator);
        PsiElement[] psiElementArray = validator.getCreatedElements();
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vaadin/actions/CreateCustomComponentAction", "invokeDialog"));
        }
        return psiElementArray;
    }

    protected String getErrorTitle() {
        return "Cannot Create Custom Component";
    }

    protected String getCommandName() {
        return "Create Custom Component";
    }

    protected String getActionName(PsiDirectory directory, String newName) {
        return "Creating Vaadin custom component '" + newName + "'";
    }
}

