/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.database;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.intellij.CommonBundle;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.view.DatabaseView;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.database.AndroidDataSource;
import org.jetbrains.android.database.AndroidDbConnectionInfo;
import org.jetbrains.android.database.AndroidDbErrorReporterImpl;
import org.jetbrains.android.database.AndroidDbUtil;
import org.jetbrains.android.database.AndroidRemoteDataBaseManager;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidUploadDatabaseAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.database.AndroidUploadDatabaseAction");

    public void update(AnActionEvent e) {
        Project project = e.getProject();
        e.getPresentation().setVisible(project != null && !AndroidUploadDatabaseAction.getSelectedAndroidDataSources(e).isEmpty());
    }

    public void actionPerformed(AnActionEvent e) {
        final Project project = e.getProject();
        assert (project != null);
        final List<AndroidDataSource> dataSources = AndroidUploadDatabaseAction.getSelectedAndroidDataSources(e);
        final AndroidDebugBridge debugBridge = AndroidSdkUtils.getDebugBridge((Project)project);
        if (debugBridge == null) {
            Messages.showErrorDialog((Project)project, (String)AndroidBundle.message((String)"cannot.connect.to.adb.error", (Object[])new Object[0]), (String)CommonBundle.getErrorTitle());
            return;
        }
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, AndroidBundle.message((String)"android.db.uploading.progress.title", (Object[])new Object[0]), true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/android/database/AndroidUploadDatabaseAction$1", "run"));
                }
                for (AndroidDataSource dataSource : dataSources) {
                    indicator.setText("Uploading " + dataSource.getName());
                    Object object = AndroidDbUtil.DB_SYNC_LOCK;
                    synchronized (object) {
                        AndroidUploadDatabaseAction.uploadDatabase(project, dataSource, indicator, debugBridge);
                    }
                    indicator.checkCanceled();
                }
            }
        });
    }

    @NotNull
    private static List<AndroidDataSource> getSelectedAndroidDataSources(AnActionEvent e) {
        Set dataSourceElements = DatabaseView.getSelectedElements((DataContext)e.getDataContext(), DbDataSource.class);
        if (dataSourceElements.isEmpty()) {
            List<AndroidDataSource> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/database/AndroidUploadDatabaseAction", "getSelectedAndroidDataSources"));
            }
            return list;
        }
        ArrayList<AndroidDataSource> androidDataSources = new ArrayList<AndroidDataSource>();
        for (DbDataSource element : dataSourceElements) {
            DatabaseSystem delegate = element.getDelegate();
            if (!(delegate instanceof AndroidDataSource)) continue;
            androidDataSources.add((AndroidDataSource)delegate);
        }
        ArrayList<AndroidDataSource> arrayList = androidDataSources;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/database/AndroidUploadDatabaseAction", "getSelectedAndroidDataSources"));
        }
        return arrayList;
    }

    private static void uploadDatabase(@NotNull Project project, @NotNull AndroidDataSource dataSource, @NotNull ProgressIndicator indicator, @NotNull AndroidDebugBridge debugBridge) {
        Long modificationTime;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/database/AndroidUploadDatabaseAction", "uploadDatabase"));
        }
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "org/jetbrains/android/database/AndroidUploadDatabaseAction", "uploadDatabase"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/android/database/AndroidUploadDatabaseAction", "uploadDatabase"));
        }
        if (debugBridge == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugBridge", "org/jetbrains/android/database/AndroidUploadDatabaseAction", "uploadDatabase"));
        }
        String localDbFilePath = dataSource.buildLocalDbFileOsPath();
        AndroidDbErrorReporterImpl errorReporter = new AndroidDbErrorReporterImpl(project, dataSource, true);
        AndroidDbConnectionInfo dbConnectionInfo = AndroidDbUtil.checkDataSource(dataSource, debugBridge, errorReporter);
        if (dbConnectionInfo == null) {
            return;
        }
        IDevice device = dbConnectionInfo.getDevice();
        String packageName = dbConnectionInfo.getPackageName();
        String dbName = dbConnectionInfo.getDbName();
        String localFileMd5Hash = AndroidUploadDatabaseAction.getLocalFileMd5Hash(new File(localDbFilePath));
        String deviceId = AndroidDbUtil.getDeviceId(device);
        boolean external = dbConnectionInfo.isExternal();
        if (localFileMd5Hash == null || deviceId == null) {
            return;
        }
        if (AndroidDbUtil.uploadDatabase(device, packageName, dbName, external, localDbFilePath, indicator, errorReporter) && (modificationTime = AndroidDbUtil.getModificationTime(device, packageName, dbName, external, errorReporter, indicator)) != null) {
            AndroidRemoteDataBaseManager.MyDatabaseInfo dbInfo = AndroidRemoteDataBaseManager.getInstance().getDatabaseInfo(deviceId, packageName, dbName, external);
            if (dbInfo == null) {
                dbInfo = new AndroidRemoteDataBaseManager.MyDatabaseInfo();
            }
            dbInfo.modificationTime = modificationTime;
            AndroidRemoteDataBaseManager.getInstance().setDatabaseInfo(deviceId, packageName, dbName, dbInfo, external);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static String getLocalFileMd5Hash(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/android/database/AndroidUploadDatabaseAction", "getLocalFileMd5Hash"));
        }
        try {
            byte[] buffer = new byte[1024];
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            try (BufferedInputStream fis = new BufferedInputStream(new FileInputStream(file));){
                int read;
                while ((read = ((InputStream)fis).read(buffer)) > 0) {
                    md5.update(buffer, 0, read);
                }
            }
            StringBuilder builder = new StringBuilder();
            for (byte b : md5.digest()) {
                builder.append(Integer.toString((b & 0xFF) + 256, 16).substring(1));
            }
            return builder.toString();
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return null;
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }
}

