/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.database;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.intellij.CommonBundle;
import com.intellij.database.SynchronizeHandler;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.HashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.android.database.AndroidDataSource;
import org.jetbrains.android.database.AndroidDbConnectionInfo;
import org.jetbrains.android.database.AndroidDbErrorReporter;
import org.jetbrains.android.database.AndroidDbErrorReporterImpl;
import org.jetbrains.android.database.AndroidDbUtil;
import org.jetbrains.android.database.AndroidRemoteDataBaseManager;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class AndroidSynchronizeHandler
extends SynchronizeHandler {
    public void synchronizationStarted(@NotNull Project project, @NotNull Set<DbDataSource> elements) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/database/AndroidSynchronizeHandler", "synchronizationStarted"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "org/jetbrains/android/database/AndroidSynchronizeHandler", "synchronizationStarted"));
        }
        ArrayList<AndroidDataSource> dataSourcesToSync = new ArrayList<AndroidDataSource>();
        for (DbDataSource element : elements) {
            DatabaseSystem delegate = element.getDelegate();
            if (!(delegate instanceof AndroidDataSource)) continue;
            dataSourcesToSync.add((AndroidDataSource)delegate);
        }
        if (dataSourcesToSync.isEmpty()) {
            return;
        }
        Set<AndroidDataSource> syncedDataSources = AndroidSynchronizeHandler.doSynchronize(project, dataSourcesToSync);
        Iterator<DbDataSource> it = elements.iterator();
        while (it.hasNext()) {
            DbDataSource element = it.next();
            DatabaseSystem delegate = element.getDelegate();
            if (!(delegate instanceof AndroidDataSource) || syncedDataSources.contains(delegate)) continue;
            it.remove();
        }
    }

    @NotNull
    public static Set<AndroidDataSource> doSynchronize(@NotNull Project project, @NotNull Collection<AndroidDataSource> dataSourcesToSync) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/database/AndroidSynchronizeHandler", "doSynchronize"));
        }
        if (dataSourcesToSync == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourcesToSync", "org/jetbrains/android/database/AndroidSynchronizeHandler", "doSynchronize"));
        }
        AndroidDebugBridge debugBridge = AndroidSdkUtils.getDebugBridge((Project)project);
        if (debugBridge == null) {
            Messages.showErrorDialog((Project)project, (String)AndroidBundle.message((String)"cannot.connect.to.adb.error", (Object[])new Object[0]), (String)CommonBundle.getErrorTitle());
            Set<AndroidDataSource> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/database/AndroidSynchronizeHandler", "doSynchronize"));
            }
            return set;
        }
        Set<AndroidDataSource> syncedDataSources = Collections.synchronizedSet(new HashSet(dataSourcesToSync));
        MySynchronizeDataSourcesTask task = new MySynchronizeDataSourcesTask(project, debugBridge, syncedDataSources);
        ProgressManager.getInstance().run((Task)task);
        Set<AndroidDataSource> set = syncedDataSources;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/database/AndroidSynchronizeHandler", "doSynchronize"));
        }
        return set;
    }

    private static void doSynchronizeDataSource(@NotNull Project project, @NotNull AndroidDataSource dataSource, @NotNull ProgressIndicator progressIndicator, @NotNull AndroidDebugBridge debugBridge, @NotNull AndroidDbErrorReporter errorReporter) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/database/AndroidSynchronizeHandler", "doSynchronizeDataSource"));
        }
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "org/jetbrains/android/database/AndroidSynchronizeHandler", "doSynchronizeDataSource"));
        }
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "org/jetbrains/android/database/AndroidSynchronizeHandler", "doSynchronizeDataSource"));
        }
        if (debugBridge == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugBridge", "org/jetbrains/android/database/AndroidSynchronizeHandler", "doSynchronizeDataSource"));
        }
        if (errorReporter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorReporter", "org/jetbrains/android/database/AndroidSynchronizeHandler", "doSynchronizeDataSource"));
        }
        AndroidDbConnectionInfo dbConnectionInfo = AndroidDbUtil.checkDataSource(dataSource, debugBridge, errorReporter);
        if (dbConnectionInfo == null) {
            return;
        }
        IDevice device = dbConnectionInfo.getDevice();
        String deviceId = AndroidDbUtil.getDeviceId(device);
        if (deviceId == null) {
            return;
        }
        String packageName = dbConnectionInfo.getPackageName();
        String dbName = dbConnectionInfo.getDbName();
        boolean external = dbConnectionInfo.isExternal();
        Long modificationTime = AndroidDbUtil.getModificationTime(device, packageName, dbName, external, errorReporter, progressIndicator);
        progressIndicator.checkCanceled();
        if (modificationTime == null) {
            return;
        }
        AndroidRemoteDataBaseManager remoteDbManager = AndroidRemoteDataBaseManager.getInstance();
        AndroidRemoteDataBaseManager.MyDatabaseInfo info = remoteDbManager.getDatabaseInfo(deviceId, packageName, dbName, external);
        if (info == null) {
            info = new AndroidRemoteDataBaseManager.MyDatabaseInfo();
        }
        progressIndicator.checkCanceled();
        File localDbFile = new File(dataSource.buildLocalDbFileOsPath());
        info.referringProjects.add(FileUtil.toCanonicalPath((String)project.getBasePath()));
        if (!(localDbFile.exists() && modificationTime.equals(info.modificationTime) || !AndroidDbUtil.downloadDatabase(device, packageName, dbName, external, localDbFile, progressIndicator, errorReporter))) {
            info.modificationTime = modificationTime;
            remoteDbManager.setDatabaseInfo(deviceId, packageName, dbName, info, external);
        }
    }

    private static class MySynchronizeDataSourcesTask
    extends Task.Modal {
        private final Project myProject;
        private final AndroidDebugBridge myDebugBridge;
        private final Set<AndroidDataSource> myDataSources;

        public MySynchronizeDataSourcesTask(@NotNull Project project, @NotNull AndroidDebugBridge debugBridge, @NotNull Set<AndroidDataSource> dataSources) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/database/AndroidSynchronizeHandler$MySynchronizeDataSourcesTask", "<init>"));
            }
            if (debugBridge == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugBridge", "org/jetbrains/android/database/AndroidSynchronizeHandler$MySynchronizeDataSourcesTask", "<init>"));
            }
            if (dataSources == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSources", "org/jetbrains/android/database/AndroidSynchronizeHandler$MySynchronizeDataSourcesTask", "<init>"));
            }
            super(project, AndroidBundle.message((String)"android.db.downloading.progress.title", (Object[])new Object[0]), true);
            this.myProject = project;
            this.myDebugBridge = debugBridge;
            this.myDataSources = dataSources;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/android/database/AndroidSynchronizeHandler$MySynchronizeDataSourcesTask", "run"));
            }
            Iterator<AndroidDataSource> it = this.myDataSources.iterator();
            while (it.hasNext()) {
                AndroidDataSource dataSource = it.next();
                indicator.setText("Downloading '" + dataSource.getName() + "'");
                Object object = AndroidDbUtil.DB_SYNC_LOCK;
                synchronized (object) {
                    AndroidDbErrorReporterImpl errorReporter = new AndroidDbErrorReporterImpl(this.myProject, dataSource, false);
                    AndroidSynchronizeHandler.doSynchronizeDataSource(this.myProject, dataSource, indicator, this.myDebugBridge, errorReporter);
                    if (errorReporter.hasError()) {
                        it.remove();
                    }
                }
                indicator.checkCanceled();
            }
        }
    }
}

