/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.database;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.MultiLineReceiver;
import com.android.ddmlib.SyncService;
import com.android.tools.idea.ddms.DevicePropertyUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.URLUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.jetbrains.android.database.AndroidDataSource;
import org.jetbrains.android.database.AndroidDbConnectionInfo;
import org.jetbrains.android.database.AndroidDbErrorReporter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AndroidDbUtil {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.database.AndroidDbUtil");
    public static final Object DB_SYNC_LOCK = new Object();
    public static final String TEMP_REMOTE_DB_PATH = "/data/local/tmp/intellij_temp_db_file";
    public static final String TEMP_REMOTE_GET_MODIFICATION_TIME_TOOL_PATH = "/data/local/tmp/intellij_native_tools/get_modification_time";
    public static final long DB_COPYING_TIMEOUT_SEC = 30L;
    public static final int SHELL_COMMAND_TIMEOUT_SECONDS = 2;
    private static final String DEVICE_ID_EMULATOR_PREFIX = "EMULATOR_";
    private static final String DEVICE_ID_SERIAL_NUMBER_PREFIX = "SERIAL_NUMBER_";
    private static final Pattern RUN_AS_UNKNOWN_PACKAGE_ERROR_PATTERN = Pattern.compile("run-as: Package '\\S+' is unknown");

    private AndroidDbUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean uploadDatabase(@NotNull IDevice device, @NotNull String packageName, @NotNull String dbName, boolean external, @NotNull String localDbPath, @NotNull ProgressIndicator progressIndicator, @NotNull AndroidDbErrorReporter errorReporter) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "org/jetbrains/android/database/AndroidDbUtil", "uploadDatabase"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "org/jetbrains/android/database/AndroidDbUtil", "uploadDatabase"));
        }
        if (dbName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dbName", "org/jetbrains/android/database/AndroidDbUtil", "uploadDatabase"));
        }
        if (localDbPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localDbPath", "org/jetbrains/android/database/AndroidDbUtil", "uploadDatabase"));
        }
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "org/jetbrains/android/database/AndroidDbUtil", "uploadDatabase"));
        }
        if (errorReporter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorReporter", "org/jetbrains/android/database/AndroidDbUtil", "uploadDatabase"));
        }
        try {
            try (SyncService syncService = device.getSyncService();){
                syncService.pushFile(localDbPath, TEMP_REMOTE_DB_PATH, (SyncService.ISyncProgressMonitor)new MySyncProgressMonitor(progressIndicator));
            }
            String remoteDbPath = AndroidDbUtil.getDatabaseRemoteFilePath(packageName, dbName, external);
            String remoteDbDirPath = remoteDbPath.substring(0, remoteDbPath.lastIndexOf(47));
            MyShellOutputReceiver outputReceiver = new MyShellOutputReceiver(progressIndicator, device);
            device.executeShellCommand(AndroidDbUtil.getRunAsPrefix(packageName, external) + "mkdir " + remoteDbDirPath, (IShellOutputReceiver)outputReceiver, 30L, TimeUnit.SECONDS);
            String output = outputReceiver.getOutput();
            if (!output.isEmpty() && !output.startsWith("mkdir failed")) {
                errorReporter.reportError(output);
                return false;
            }
            if (!external && !AndroidDbUtil.recreateRemoteFile(device, packageName, remoteDbPath, errorReporter, progressIndicator)) {
                return false;
            }
            outputReceiver = new MyShellOutputReceiver(progressIndicator, device);
            device.executeShellCommand(AndroidDbUtil.getRunAsPrefix(packageName, external) + "cat " + TEMP_REMOTE_DB_PATH + " >" + remoteDbPath, (IShellOutputReceiver)outputReceiver, 30L, TimeUnit.SECONDS);
            output = outputReceiver.getOutput();
            if (!output.isEmpty()) {
                errorReporter.reportError(output);
                return false;
            }
            progressIndicator.checkCanceled();
        }
        catch (Exception e) {
            errorReporter.reportError(e);
            return false;
        }
        return true;
    }

    @NotNull
    private static String getRunAsPrefix(@NotNull String packageName, boolean external) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "org/jetbrains/android/database/AndroidDbUtil", "getRunAsPrefix"));
        }
        String string = external ? "" : "run-as " + packageName + " ";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/database/AndroidDbUtil", "getRunAsPrefix"));
        }
        return string;
    }

    private static boolean recreateRemoteFile(IDevice device, String packageName, String remotePath, AndroidDbErrorReporter errorReporter, ProgressIndicator progressIndicator) throws Exception {
        MyShellOutputReceiver outputReceiver = new MyShellOutputReceiver(progressIndicator, device);
        device.executeShellCommand("run-as " + packageName + " rm " + remotePath, (IShellOutputReceiver)outputReceiver, 30L, TimeUnit.SECONDS);
        String output = outputReceiver.getOutput();
        if (!output.isEmpty() && !output.startsWith("rm failed")) {
            errorReporter.reportError(output);
            return false;
        }
        outputReceiver = new MyShellOutputReceiver(progressIndicator, device);
        device.executeShellCommand("run-as " + packageName + " touch " + remotePath, (IShellOutputReceiver)outputReceiver, 30L, TimeUnit.SECONDS);
        output = outputReceiver.getOutput();
        if (!output.isEmpty()) {
            errorReporter.reportError(output);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean downloadDatabase(@NotNull IDevice device, @NotNull String packageName, @NotNull String dbName, boolean external, @NotNull File localDbFile, @NotNull ProgressIndicator progressIndicator, @NotNull AndroidDbErrorReporter errorReporter) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "org/jetbrains/android/database/AndroidDbUtil", "downloadDatabase"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "org/jetbrains/android/database/AndroidDbUtil", "downloadDatabase"));
        }
        if (dbName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dbName", "org/jetbrains/android/database/AndroidDbUtil", "downloadDatabase"));
        }
        if (localDbFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localDbFile", "org/jetbrains/android/database/AndroidDbUtil", "downloadDatabase"));
        }
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "org/jetbrains/android/database/AndroidDbUtil", "downloadDatabase"));
        }
        if (errorReporter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorReporter", "org/jetbrains/android/database/AndroidDbUtil", "downloadDatabase"));
        }
        try {
            MyShellOutputReceiver receiver = new MyShellOutputReceiver(progressIndicator, device);
            device.executeShellCommand(AndroidDbUtil.getRunAsPrefix(packageName, external) + "cat " + AndroidDbUtil.getDatabaseRemoteFilePath(packageName, dbName, external) + " >" + TEMP_REMOTE_DB_PATH, (IShellOutputReceiver)receiver, 30L, TimeUnit.SECONDS);
            String output = receiver.getOutput();
            if (!output.isEmpty()) {
                errorReporter.reportError(output);
                return false;
            }
            progressIndicator.checkCanceled();
            File parent = localDbFile.getParentFile();
            if (!parent.exists() && !parent.mkdirs()) {
                errorReporter.reportError("cannot create directory '" + parent.getPath() + "'");
                return false;
            }
            try (SyncService syncService = device.getSyncService();){
                syncService.pullFile(TEMP_REMOTE_DB_PATH, localDbFile.getPath(), (SyncService.ISyncProgressMonitor)new MySyncProgressMonitor(progressIndicator));
            }
        }
        catch (Exception e) {
            errorReporter.reportError(e);
            return false;
        }
        return true;
    }

    @Nullable
    public static AndroidDbConnectionInfo checkDataSource(@NotNull AndroidDataSource dataSource, @NotNull AndroidDebugBridge debugBridge, @NotNull AndroidDbErrorReporter errorReporter) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "org/jetbrains/android/database/AndroidDbUtil", "checkDataSource"));
        }
        if (debugBridge == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugBridge", "org/jetbrains/android/database/AndroidDbUtil", "checkDataSource"));
        }
        if (errorReporter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorReporter", "org/jetbrains/android/database/AndroidDbUtil", "checkDataSource"));
        }
        AndroidDataSource.State state = dataSource.getState();
        String deviceId = state.deviceId;
        if (deviceId == null) {
            errorReporter.reportError("device is not specified");
            return null;
        }
        IDevice device = AndroidDbUtil.getDeviceById(debugBridge, deviceId);
        if (device == null) {
            errorReporter.reportError("device '" + AndroidDbUtil.getPresentableNameFromDeviceId(deviceId) + "' is not connected");
            return null;
        }
        if (!device.isOnline()) {
            errorReporter.reportError("the device is not online");
            return null;
        }
        String packageName = dataSource.getState().packageName;
        if (packageName == null || packageName.length() == 0) {
            errorReporter.reportError("package name is not specified");
            return null;
        }
        String dbName = dataSource.getState().databaseName;
        if (dbName == null || dbName.length() == 0) {
            errorReporter.reportError("database name is not specified");
            return null;
        }
        return new AndroidDbConnectionInfo(device, packageName, dbName, dataSource.getState().external);
    }

    @Nullable
    private static IDevice getDeviceById(@NotNull AndroidDebugBridge debugBridge, @NotNull String deviceId) {
        if (debugBridge == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugBridge", "org/jetbrains/android/database/AndroidDbUtil", "getDeviceById"));
        }
        if (deviceId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deviceId", "org/jetbrains/android/database/AndroidDbUtil", "getDeviceById"));
        }
        for (IDevice device : debugBridge.getDevices()) {
            if (!deviceId.equals(AndroidDbUtil.getDeviceId(device))) continue;
            return device;
        }
        return null;
    }

    private static boolean installGetModificationTimeTool(@NotNull IDevice device, @NotNull AndroidDbErrorReporter reporter, @NotNull ProgressIndicator progressIndicator) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "org/jetbrains/android/database/AndroidDbUtil", "installGetModificationTimeTool"));
        }
        if (reporter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reporter", "org/jetbrains/android/database/AndroidDbUtil", "installGetModificationTimeTool"));
        }
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "org/jetbrains/android/database/AndroidDbUtil", "installGetModificationTimeTool"));
        }
        String abi = device.getProperty("ro.product.cpu.abi");
        if (abi == null) {
            abi = "armeabi";
        }
        String pieDir = AndroidDbUtil.arePositionIndependentExecutablesSupported(device) ? "pie" : "non_pie";
        String urlStr = "/native_tools/" + pieDir + "/" + abi + "/get_modification_time";
        URL url = AndroidDbUtil.class.getResource(urlStr);
        if (url == null) {
            LOG.error("Cannot find resource " + urlStr);
            return false;
        }
        String remoteToolPath = TEMP_REMOTE_GET_MODIFICATION_TIME_TOOL_PATH;
        if (!AndroidDbUtil.pushGetModificationTimeTool(device, url, reporter, progressIndicator, TEMP_REMOTE_GET_MODIFICATION_TIME_TOOL_PATH)) {
            return false;
        }
        String chmodResult = AndroidDbUtil.executeSingleCommand(device, reporter, "chmod 755 /data/local/tmp/intellij_native_tools/get_modification_time");
        if (chmodResult == null) {
            return false;
        }
        if (!chmodResult.isEmpty()) {
            reporter.reportError(chmodResult);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean pushGetModificationTimeTool(@NotNull IDevice device, @NotNull URL url, @NotNull AndroidDbErrorReporter reporter, @NotNull ProgressIndicator progressIndicator, @NotNull String remotePath) {
        File toolLocalCopy;
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "org/jetbrains/android/database/AndroidDbUtil", "pushGetModificationTimeTool"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/android/database/AndroidDbUtil", "pushGetModificationTimeTool"));
        }
        if (reporter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reporter", "org/jetbrains/android/database/AndroidDbUtil", "pushGetModificationTimeTool"));
        }
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "org/jetbrains/android/database/AndroidDbUtil", "pushGetModificationTimeTool"));
        }
        if (remotePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remotePath", "org/jetbrains/android/database/AndroidDbUtil", "pushGetModificationTimeTool"));
        }
        try {
            toolLocalCopy = FileUtil.createTempFile((String)"android_get_modification_time_tool", (String)"tmp");
        }
        catch (IOException e) {
            reporter.reportError(e);
            return false;
        }
        try {
            if (!AndroidDbUtil.copyResourceToFile(url, toolLocalCopy, reporter)) {
                boolean e = false;
                return e;
            }
            try (SyncService service = device.getSyncService();){
                service.pushFile(toolLocalCopy.getPath(), remotePath, (SyncService.ISyncProgressMonitor)new MySyncProgressMonitor(progressIndicator));
            }
            catch (Exception e) {
                reporter.reportError(e);
                boolean bl = false;
                FileUtil.delete((File)toolLocalCopy);
                return bl;
            }
        }
        finally {
            FileUtil.delete((File)toolLocalCopy);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean copyResourceToFile(@NotNull URL url, @NotNull File file, @NotNull AndroidDbErrorReporter reporter) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/android/database/AndroidDbUtil", "copyResourceToFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/android/database/AndroidDbUtil", "copyResourceToFile"));
        }
        if (reporter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reporter", "org/jetbrains/android/database/AndroidDbUtil", "copyResourceToFile"));
        }
        try {
            BufferedInputStream is = new BufferedInputStream(URLUtil.openStream((URL)url));
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
            try {
                FileUtil.copy((InputStream)is, (OutputStream)os);
            }
            finally {
                ((InputStream)is).close();
                ((OutputStream)os).close();
            }
        }
        catch (IOException e) {
            reporter.reportError(e);
            return false;
        }
        return true;
    }

    @Nullable
    public static Long getModificationTime(@NotNull IDevice device, @NotNull String packageName, @NotNull String dbName, boolean external, @NotNull AndroidDbErrorReporter errorReporter, @NotNull ProgressIndicator progressIndicator) {
        Long l;
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "org/jetbrains/android/database/AndroidDbUtil", "getModificationTime"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "org/jetbrains/android/database/AndroidDbUtil", "getModificationTime"));
        }
        if (dbName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dbName", "org/jetbrains/android/database/AndroidDbUtil", "getModificationTime"));
        }
        if (errorReporter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorReporter", "org/jetbrains/android/database/AndroidDbUtil", "getModificationTime"));
        }
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "org/jetbrains/android/database/AndroidDbUtil", "getModificationTime"));
        }
        String path = TEMP_REMOTE_GET_MODIFICATION_TIME_TOOL_PATH;
        String lsResult = AndroidDbUtil.executeSingleCommand(device, errorReporter, "ls /data/local/tmp/intellij_native_tools/get_modification_time");
        if (lsResult == null) {
            return null;
        }
        boolean reinstalled = false;
        if (!lsResult.equals(TEMP_REMOTE_GET_MODIFICATION_TIME_TOOL_PATH)) {
            if (!AndroidDbUtil.installGetModificationTimeTool(device, errorReporter, progressIndicator)) {
                return null;
            }
            reinstalled = true;
        }
        if ((l = AndroidDbUtil.doGetModificationTime(device, packageName, dbName, external, errorReporter)) != null) {
            return l;
        }
        if (!reinstalled) {
            AndroidDbUtil.installGetModificationTimeTool(device, errorReporter, progressIndicator);
        }
        return null;
    }

    @Nullable
    private static Long doGetModificationTime(@NotNull IDevice device, @NotNull String packageName, @NotNull String dbName, boolean external, @NotNull AndroidDbErrorReporter errorReporter) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "org/jetbrains/android/database/AndroidDbUtil", "doGetModificationTime"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "org/jetbrains/android/database/AndroidDbUtil", "doGetModificationTime"));
        }
        if (dbName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dbName", "org/jetbrains/android/database/AndroidDbUtil", "doGetModificationTime"));
        }
        if (errorReporter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorReporter", "org/jetbrains/android/database/AndroidDbUtil", "doGetModificationTime"));
        }
        String databaseRemoteFilePath = AndroidDbUtil.getDatabaseRemoteFilePath(packageName, dbName, external);
        String command = AndroidDbUtil.getRunAsPrefix(packageName, external) + TEMP_REMOTE_GET_MODIFICATION_TIME_TOOL_PATH + " " + databaseRemoteFilePath;
        String s = AndroidDbUtil.executeSingleCommand(device, errorReporter, command);
        if (s != null && s.contains("Permission denied")) {
            s = AndroidDbUtil.executeSingleCommand(device, errorReporter, "/data/local/tmp/intellij_native_tools/get_modification_time " + databaseRemoteFilePath);
        }
        if (s == null) {
            return null;
        }
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            errorReporter.reportError(s);
            return null;
        }
    }

    @Nullable
    private static String executeSingleCommand(@NotNull IDevice device, @NotNull AndroidDbErrorReporter errorReporter, @NotNull String command) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "org/jetbrains/android/database/AndroidDbUtil", "executeSingleCommand"));
        }
        if (errorReporter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorReporter", "org/jetbrains/android/database/AndroidDbUtil", "executeSingleCommand"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/android/database/AndroidDbUtil", "executeSingleCommand"));
        }
        MyShellOutputReceiver receiver = new MyShellOutputReceiver(null, device);
        try {
            device.executeShellCommand(command, (IShellOutputReceiver)receiver, 2L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            errorReporter.reportError(e);
            return null;
        }
        return receiver.getOutput();
    }

    @Nullable
    public static String getDeviceId(@NotNull IDevice device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "org/jetbrains/android/database/AndroidDbUtil", "getDeviceId"));
        }
        if (device.isEmulator()) {
            String avdName = device.getAvdName();
            return avdName == null ? null : DEVICE_ID_EMULATOR_PREFIX + AndroidDbUtil.replaceByDirAllowedName(avdName);
        }
        String serialNumber = device.getSerialNumber();
        if (serialNumber != null && serialNumber.length() > 0) {
            return DEVICE_ID_SERIAL_NUMBER_PREFIX + AndroidDbUtil.replaceByDirAllowedName(serialNumber);
        }
        String manufacturer = DevicePropertyUtil.getManufacturer((IDevice)device, (String)"");
        String model = DevicePropertyUtil.getModel((IDevice)device, (String)"");
        if (manufacturer.length() > 0 || model.length() > 0) {
            return AndroidDbUtil.replaceByDirAllowedName(manufacturer + "_" + model);
        }
        return null;
    }

    @NotNull
    public static String getPresentableNameFromDeviceId(@NotNull String deviceId) {
        if (deviceId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deviceId", "org/jetbrains/android/database/AndroidDbUtil", "getPresentableNameFromDeviceId"));
        }
        if (deviceId.startsWith(DEVICE_ID_EMULATOR_PREFIX)) {
            String string = "emulator: " + deviceId.substring(DEVICE_ID_EMULATOR_PREFIX.length());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/database/AndroidDbUtil", "getPresentableNameFromDeviceId"));
            }
            return string;
        }
        if (deviceId.startsWith(DEVICE_ID_SERIAL_NUMBER_PREFIX)) {
            String string = "serial: " + deviceId.substring(DEVICE_ID_SERIAL_NUMBER_PREFIX.length());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/database/AndroidDbUtil", "getPresentableNameFromDeviceId"));
            }
            return string;
        }
        String string = deviceId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/database/AndroidDbUtil", "getPresentableNameFromDeviceId"));
        }
        return string;
    }

    @NotNull
    private static String replaceByDirAllowedName(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "org/jetbrains/android/database/AndroidDbUtil", "replaceByDirAllowedName"));
        }
        StringBuilder builder = new StringBuilder();
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            if (!Character.isJavaIdentifierPart(c)) {
                c = '_';
            }
            builder.append(c);
        }
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/database/AndroidDbUtil", "replaceByDirAllowedName"));
        }
        return string;
    }

    private static boolean arePositionIndependentExecutablesSupported(IDevice device) {
        try {
            return Integer.parseInt(device.getProperty("ro.build.version.sdk")) >= 16;
        }
        catch (NumberFormatException e) {
            LOG.info((Throwable)e);
            return false;
        }
    }

    @NotNull
    public static String getInternalDatabasesRemoteDirPath(@NotNull String packageName) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "org/jetbrains/android/database/AndroidDbUtil", "getInternalDatabasesRemoteDirPath"));
        }
        String string = "/data/data/" + packageName + "/databases";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/database/AndroidDbUtil", "getInternalDatabasesRemoteDirPath"));
        }
        return string;
    }

    @NotNull
    public static String getDatabaseRemoteFilePath(@NotNull String packageName, @NotNull String dbName, boolean external) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "org/jetbrains/android/database/AndroidDbUtil", "getDatabaseRemoteFilePath"));
        }
        if (dbName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dbName", "org/jetbrains/android/database/AndroidDbUtil", "getDatabaseRemoteFilePath"));
        }
        if (dbName.startsWith("/")) {
            dbName = dbName.substring(1);
        }
        if (!external) {
            String string = AndroidDbUtil.getInternalDatabasesRemoteDirPath(packageName) + "/" + dbName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/database/AndroidDbUtil", "getDatabaseRemoteFilePath"));
            }
            return string;
        }
        String string = "$EXTERNAL_STORAGE/Android/data/" + packageName + "/" + dbName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/database/AndroidDbUtil", "getDatabaseRemoteFilePath"));
        }
        return string;
    }

    private static class MySyncProgressMonitor
    implements SyncService.ISyncProgressMonitor {
        private final ProgressIndicator myProgressIndicator;

        public MySyncProgressMonitor(@NotNull ProgressIndicator progressIndicator) {
            if (progressIndicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "org/jetbrains/android/database/AndroidDbUtil$MySyncProgressMonitor", "<init>"));
            }
            this.myProgressIndicator = progressIndicator;
        }

        public void start(int totalWork) {
        }

        public void stop() {
        }

        public boolean isCanceled() {
            return this.myProgressIndicator.isCanceled();
        }

        public void startSubTask(String name) {
        }

        public void advance(int work) {
        }
    }

    private static class MyShellOutputReceiver
    extends MultiLineReceiver {
        @Nullable
        private final ProgressIndicator myProgressIndicator;
        private final StringBuilder myOutputBuilder;
        private final boolean myAndroid43;

        public MyShellOutputReceiver(@Nullable ProgressIndicator progressIndicator, @NotNull IDevice device) {
            if (device == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "org/jetbrains/android/database/AndroidDbUtil$MyShellOutputReceiver", "<init>"));
            }
            this.myOutputBuilder = new StringBuilder();
            this.myProgressIndicator = progressIndicator;
            this.myAndroid43 = "18".equals(device.getProperty("ro.build.version.sdk"));
        }

        public void processNewLines(String[] lines) {
            for (String line : lines) {
                String s = line.trim();
                if (s.length() <= 0) continue;
                LOG.debug("ADB_SHELL: " + s);
                if (this.myOutputBuilder.length() > 0) {
                    this.myOutputBuilder.append('\n');
                }
                this.myOutputBuilder.append(s);
                if (!this.myAndroid43 || !RUN_AS_UNKNOWN_PACKAGE_ERROR_PATTERN.matcher(s).matches()) continue;
                this.myOutputBuilder.append(". \nUnfortunately database support doesn't work for Android 4.3 devices because of the bug https://code.google.com/p/android/issues/detail?id=58373");
            }
        }

        public boolean isCancelled() {
            return this.myProgressIndicator != null && this.myProgressIndicator.isCanceled();
        }

        @NotNull
        public String getOutput() {
            String string = this.myOutputBuilder.toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/database/AndroidDbUtil$MyShellOutputReceiver", "getOutput"));
            }
            return string;
        }
    }
}

