/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.database;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.project.Project;
import org.jetbrains.android.database.AndroidDataSource;
import org.jetbrains.android.database.AndroidDbErrorReporter;
import org.jetbrains.annotations.NotNull;

class AndroidDbErrorReporterImpl
extends AndroidDbErrorReporter {
    private final Project myProject;
    private final AndroidDataSource myDataSource;
    private final boolean myUpload;

    public AndroidDbErrorReporterImpl(@NotNull Project project, @NotNull AndroidDataSource dataSource, boolean upload) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/database/AndroidDbErrorReporterImpl", "<init>"));
        }
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "org/jetbrains/android/database/AndroidDbErrorReporterImpl", "<init>"));
        }
        this.myProject = project;
        this.myDataSource = dataSource;
        this.myUpload = upload;
    }

    @Override
    public synchronized void reportError(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/android/database/AndroidDbErrorReporterImpl", "reportError"));
        }
        super.reportError(message);
        Notification notification = new Notification("Android Data Source Manager", "Data Source Synchronization Error", "Cannot " + (this.myUpload ? "upload" : "synchronize") + " '" + this.myDataSource.getName() + "': " + message, NotificationType.ERROR);
        Notifications.Bus.notify((Notification)notification, (Project)this.myProject);
    }
}

