/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.database;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.FileListingService;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.MultiLineReceiver;
import com.android.tools.idea.ddms.DeviceRenderer;
import com.intellij.database.dataSource.AbstractDataSourceConfigurable;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbPsiManagerSpi;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.ui.DsUiDefaults;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.FieldPanel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.android.database.AndroidDataSource;
import org.jetbrains.android.database.AndroidDbManager;
import org.jetbrains.android.database.AndroidDbUtil;
import org.jetbrains.android.database.AndroidSynchronizeHandler;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidDataSourcePropertiesDialog
extends AbstractDataSourceConfigurable<AndroidDbManager, AndroidDataSource>
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.database.AndroidDataSourcePropertiesDialog");
    private static final String[] DEFAULT_EXTERNAL_DB_PATTERNS = new String[]{"files/"};
    private DefaultComboBoxModel myDeviceComboBoxModel;
    private String myMissingDeviceIds;
    private ComboBox myDeviceComboBox;
    private ComboBox myPackageNameComboBox;
    private ComboBox myDataBaseComboBox;
    private JPanel myPanel;
    private FieldPanel myNameField;
    private JPanel myConfigurationPanel;
    private JBRadioButton myExternalStorageRadioButton;
    private JBRadioButton myInternalStorageRadioButton;
    private IDevice mySelectedDevice;
    private final Map<String, List<String>> myDatabaseMap;
    private final AndroidDebugBridge.IDeviceChangeListener myDeviceListener;
    private final AndroidDataSource myTempDataSource;

    protected AndroidDataSourcePropertiesDialog(@NotNull AndroidDbManager manager, @NotNull Project project, @NotNull AndroidDataSource dataSource) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/android/database/AndroidDataSourcePropertiesDialog", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/database/AndroidDataSourcePropertiesDialog", "<init>"));
        }
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "org/jetbrains/android/database/AndroidDataSourcePropertiesDialog", "<init>"));
        }
        super((DbPsiManagerSpi)manager, (DatabaseSystem)dataSource, project);
        this.$$$setupUI$$$();
        this.myDeviceComboBoxModel = new DefaultComboBoxModel();
        this.mySelectedDevice = null;
        this.myDatabaseMap = ContainerUtil.newLinkedHashMap();
        this.myPanel.setBorder(DsUiDefaults.DEFAULT_PANEL_BORDER);
        this.myTempDataSource = dataSource.copy();
        this.myConfigurationPanel.setBorder(IdeBorderFactory.createEmptyBorder((int)10, (int)0, (int)0, (int)0));
        this.myNameField.setLabelText("Name:");
        this.myNameField.createComponent();
        this.myDeviceComboBox.setRenderer((ListCellRenderer)new DeviceRenderer.DeviceComboBoxRenderer(){

            protected void customizeCellRenderer(@NotNull JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/jetbrains/android/database/AndroidDataSourcePropertiesDialog$1", "customizeCellRenderer"));
                }
                if (value instanceof String) {
                    this.append(AndroidDbUtil.getPresentableNameFromDeviceId((String)value));
                } else {
                    super.customizeCellRenderer(list, value, index, selected, hasFocus);
                }
            }
        });
        this.myDeviceComboBox.setPreferredSize(new Dimension(JBUI.scale((int)300), this.myDeviceComboBox.getPreferredSize().height));
        this.myDeviceListener = new AndroidDebugBridge.IDeviceChangeListener(){

            public void deviceConnected(IDevice device) {
                AndroidDataSourcePropertiesDialog.this.addDeviceToComboBoxIfNeeded(device);
            }

            public void deviceDisconnected(IDevice device) {
            }

            public void deviceChanged(IDevice device, int changeMask) {
                if ((changeMask & 1) == changeMask) {
                    AndroidDataSourcePropertiesDialog.this.addDeviceToComboBoxIfNeeded(device);
                }
            }
        };
        this.myDeviceComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AndroidDataSourcePropertiesDialog.this.updateDataBases();
            }
        });
        ActionListener l = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AndroidDataSourcePropertiesDialog.this.updateDbCombo();
            }
        };
        this.myPackageNameComboBox.addActionListener(l);
        this.myExternalStorageRadioButton.addActionListener(l);
        this.myInternalStorageRadioButton.addActionListener(l);
        new UiNotifyConnector.Once((Component)this.myPanel, (Activatable)new Activatable.Adapter(){

            public void showNotify() {
                AndroidDataSourcePropertiesDialog.this.loadDevices();
                AndroidDataSourcePropertiesDialog.this.updateDataBases();
                AndroidDataSourcePropertiesDialog.this.updateDbCombo();
                AndroidDataSourcePropertiesDialog.this.registerDeviceListener();
            }
        });
    }

    @NotNull
    public AndroidDataSource getTempDataSource() {
        this.saveData(this.myTempDataSource);
        AndroidDataSource androidDataSource = this.myTempDataSource;
        if (androidDataSource == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/database/AndroidDataSourcePropertiesDialog", "getTempDataSource"));
        }
        return androidDataSource;
    }

    private void addDeviceToComboBoxIfNeeded(final @NotNull IDevice device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "org/jetbrains/android/database/AndroidDataSourcePropertiesDialog", "addDeviceToComboBoxIfNeeded"));
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!device.isOnline()) {
                    return;
                }
                String deviceId = AndroidDbUtil.getDeviceId(device);
                if (deviceId == null || deviceId.length() == 0) {
                    return;
                }
                for (int i = 0; i < AndroidDataSourcePropertiesDialog.this.myDeviceComboBoxModel.getSize(); ++i) {
                    Object element = AndroidDataSourcePropertiesDialog.this.myDeviceComboBoxModel.getElementAt(i);
                    if (!device.equals(element)) continue;
                    return;
                }
                AndroidDataSourcePropertiesDialog.this.myDeviceComboBoxModel.addElement(device);
                if (AndroidDataSourcePropertiesDialog.this.myMissingDeviceIds != null && AndroidDataSourcePropertiesDialog.this.myMissingDeviceIds.equals(deviceId)) {
                    AndroidDataSourcePropertiesDialog.this.myDeviceComboBoxModel.removeElement(AndroidDataSourcePropertiesDialog.this.myMissingDeviceIds);
                    AndroidDataSourcePropertiesDialog.this.myMissingDeviceIds = null;
                }
            }
        }, ModalityState.stateForComponent((Component)this.myPanel));
    }

    private void loadDevices() {
        AndroidDebugBridge bridge = AndroidSdkUtils.getDebugBridge((Project)this.myProject);
        IDevice[] devices = bridge != null ? AndroidDataSourcePropertiesDialog.getDevicesWithValidDeviceId(bridge) : new IDevice[]{};
        String deviceId = ((AndroidDataSource)this.myDataSource).getState().deviceId;
        DefaultComboBoxModel<IDevice> model = new DefaultComboBoxModel<IDevice>(devices);
        String selectedItem = null;
        if (deviceId != null && deviceId.length() > 0) {
            for (IDevice device : devices) {
                if (!deviceId.equals(AndroidDbUtil.getDeviceId(device))) continue;
                selectedItem = device;
                break;
            }
            if (selectedItem == null) {
                model.addElement((IDevice)deviceId);
                this.myMissingDeviceIds = deviceId;
                selectedItem = deviceId;
            }
        }
        this.myDeviceComboBoxModel = model;
        this.myDeviceComboBox.setModel(model);
        if (selectedItem != null) {
            this.myDeviceComboBox.setSelectedItem(selectedItem);
        }
    }

    @NotNull
    private static IDevice[] getDevicesWithValidDeviceId(@NotNull AndroidDebugBridge bridge) {
        if (bridge == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bridge", "org/jetbrains/android/database/AndroidDataSourcePropertiesDialog", "getDevicesWithValidDeviceId"));
        }
        ArrayList<IDevice> result = new ArrayList<IDevice>();
        for (IDevice device : bridge.getDevices()) {
            String deviceId;
            if (!device.isOnline() || (deviceId = AndroidDbUtil.getDeviceId(device)) == null || deviceId.length() <= 0) continue;
            result.add(device);
        }
        IDevice[] iDeviceArray = result.toArray(new IDevice[result.size()]);
        if (iDeviceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/database/AndroidDataSourcePropertiesDialog", "getDevicesWithValidDeviceId"));
        }
        return iDeviceArray;
    }

    private void updateDataBases() {
        IDevice selectedDevice;
        if (!this.myPanel.isShowing()) {
            return;
        }
        Object selectedItem = this.myDeviceComboBox.getSelectedItem();
        IDevice iDevice = selectedDevice = selectedItem instanceof IDevice ? (IDevice)selectedItem : null;
        if (selectedDevice == null) {
            this.myDatabaseMap.clear();
            this.myPackageNameComboBox.setModel(new DefaultComboBoxModel());
            this.myDataBaseComboBox.setModel(new DefaultComboBoxModel());
        } else if (!selectedDevice.equals(this.mySelectedDevice)) {
            this.loadDatabases(selectedDevice);
            this.myPackageNameComboBox.setModel(new DefaultComboBoxModel<String>(ArrayUtil.toStringArray(this.myDatabaseMap.keySet())));
            this.updateDbCombo();
        }
        this.mySelectedDevice = selectedDevice;
    }

    private void updateDbCombo() {
        boolean databaseIsCustom;
        if (!this.myPanel.isShowing()) {
            return;
        }
        String selectedPackage = this.getSelectedPackage();
        String selectedDatabase = this.getSelectedDatabase();
        boolean bl = databaseIsCustom = StringUtil.isNotEmpty((String)selectedDatabase) && ((DefaultComboBoxModel)this.myDataBaseComboBox.getModel()).getIndexOf(selectedDatabase) < 0;
        if (this.myInternalStorageRadioButton.isSelected()) {
            List<String> dbList = this.myDatabaseMap.get(selectedPackage);
            this.myDataBaseComboBox.setModel(new DefaultComboBoxModel<String>(ArrayUtil.toStringArray(dbList)));
        } else {
            this.myDataBaseComboBox.setModel(new DefaultComboBoxModel<String>(DEFAULT_EXTERNAL_DB_PATTERNS));
        }
        if (databaseIsCustom) {
            this.myDataBaseComboBox.getEditor().setItem(selectedDatabase);
        }
    }

    @NotNull
    private String getSelectedPackage() {
        String string = (String)this.myPackageNameComboBox.getEditor().getItem();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/database/AndroidDataSourcePropertiesDialog", "getSelectedPackage"));
        }
        return string;
    }

    @NotNull
    private String getSelectedDatabase() {
        String string = (String)this.myDataBaseComboBox.getEditor().getItem();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/database/AndroidDataSourcePropertiesDialog", "getSelectedDatabase"));
        }
        return string;
    }

    private void loadDatabases(@NotNull IDevice device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "org/jetbrains/android/database/AndroidDataSourcePropertiesDialog", "loadDatabases"));
        }
        this.myDatabaseMap.clear();
        FileListingService service = device.getFileListingService();
        if (service == null) {
            return;
        }
        HashSet packages = new HashSet();
        for (AndroidFacet facet : ProjectFacetManager.getInstance((Project)this.myProject).getFacets(AndroidFacet.ID)) {
            String aPackage;
            Manifest manifest = facet.getManifest();
            if (manifest == null || (aPackage = manifest.getPackage().getStringValue()) == null || aPackage.length() <= 0) continue;
            packages.add(aPackage);
        }
        if (packages.isEmpty()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        boolean tooLong = false;
        for (String aPackage : packages) {
            this.myDatabaseMap.put(aPackage, tooLong ? Collections.emptyList() : AndroidDataSourcePropertiesDialog.loadDatabases(device, aPackage));
            if (System.currentTimeMillis() - startTime <= 4000L) continue;
            tooLong = true;
        }
    }

    @NotNull
    private static List<String> loadDatabases(@NotNull IDevice device, @NotNull String packageName) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "org/jetbrains/android/database/AndroidDataSourcePropertiesDialog", "loadDatabases"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "org/jetbrains/android/database/AndroidDataSourcePropertiesDialog", "loadDatabases"));
        }
        final ArrayList<String> result = new ArrayList<String>();
        try {
            device.executeShellCommand("run-as " + packageName + " ls " + AndroidDbUtil.getInternalDatabasesRemoteDirPath(packageName), (IShellOutputReceiver)new MultiLineReceiver(){

                public void processNewLines(String[] lines) {
                    for (String line : lines) {
                        if (line.length() <= 0 || line.contains(" ")) continue;
                        result.add(line);
                    }
                }

                public boolean isCancelled() {
                    return false;
                }
            }, 2L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            LOG.debug((Throwable)e);
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/database/AndroidDataSourcePropertiesDialog", "loadDatabases"));
        }
        return arrayList;
    }

    private String getSelectedDeviceId() {
        Object item = this.myDeviceComboBox.getSelectedItem();
        if (item == null) {
            return null;
        }
        if (item instanceof String) {
            return (String)item;
        }
        assert (item instanceof IDevice);
        String deviceId = AndroidDbUtil.getDeviceId((IDevice)item);
        return deviceId != null ? deviceId : "";
    }

    @Nullable
    public JComponent createComponent() {
        return this.myPanel;
    }

    public void saveData(@NotNull AndroidDataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "org/jetbrains/android/database/AndroidDataSourcePropertiesDialog", "saveData"));
        }
        dataSource.setName(this.getNameValue());
        AndroidDataSource.State state = dataSource.getState();
        state.deviceId = this.getSelectedDeviceId();
        state.packageName = this.getSelectedPackage();
        state.databaseName = this.getSelectedDatabase();
        state.external = this.myExternalStorageRadioButton.isSelected();
        dataSource.resetUrl();
    }

    public void apply() {
        this.saveData((AndroidDataSource)this.myDataSource);
        if (DbImplUtil.canConnectTo((LocalDataSource)((LocalDataSource)this.myDataSource))) {
            AndroidSynchronizeHandler.doSynchronize(this.myProject, Collections.singletonList(this.myDataSource));
        }
        if (this.isNewDataSource()) {
            ((AndroidDbManager)this.myManager).processAddOrRemove((AndroidDataSource)this.myDataSource, true);
        }
    }

    public void reset() {
        AndroidDataSource.State state = ((AndroidDataSource)this.myDataSource).getState();
        this.myNameField.setText(StringUtil.notNullize((String)((AndroidDataSource)this.myDataSource).getName()));
        this.myInternalStorageRadioButton.setSelected(!state.external);
        this.myExternalStorageRadioButton.setSelected(state.external);
        this.myPackageNameComboBox.getEditor().setItem(StringUtil.notNullize((String)state.packageName));
        this.myDataBaseComboBox.getEditor().setItem(StringUtil.notNullize((String)state.databaseName));
    }

    private void registerDeviceListener() {
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this.myDeviceListener);
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)AndroidDataSourcePropertiesDialog.this.myDeviceListener);
            }
        });
    }

    public void dispose() {
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this);
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myNameField;
    }

    @Nls
    public String getDisplayName() {
        return this.getNameValue();
    }

    private String getNameValue() {
        return this.myNameField.getText().trim();
    }

    @Nullable
    public String getHelpTopic() {
        return null;
    }

    public boolean isModified() {
        if (this.isNewDataSource()) {
            return true;
        }
        AndroidDataSource tempDataSource = this.getTempDataSource();
        if (!StringUtil.equals((CharSequence)tempDataSource.getName(), (CharSequence)((AndroidDataSource)this.myDataSource).getName())) {
            return true;
        }
        return !tempDataSource.equalConfiguration((LocalDataSource)this.myDataSource);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBRadioButton jBRadioButton;
        JBRadioButton jBRadioButton2;
        ComboBox comboBox;
        ComboBox comboBox2;
        ComboBox comboBox3;
        JPanel jPanel;
        FieldPanel fieldPanel;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myNameField = fieldPanel = new FieldPanel();
        fieldPanel.setText("");
        jPanel2.add((Component)fieldPanel, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myConfigurationPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("html.disable", Boolean.FALSE);
        jPanel.putClientProperty("BorderFactoryClass", "");
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Device:");
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDeviceComboBox = comboBox3 = new ComboBox();
        jPanel.add((Component)comboBox3, new GridConstraints(0, 1, 1, 3, 0, 1, 2, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Package name:");
        jPanel.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPackageNameComboBox = comboBox2 = new ComboBox();
        comboBox2.setEditable(true);
        jPanel.add((Component)comboBox2, new GridConstraints(1, 1, 1, 3, 0, 1, 2, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Database:");
        jPanel.add((Component)jBLabel3, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDataBaseComboBox = comboBox = new ComboBox();
        comboBox.setEditable(true);
        jPanel.add((Component)comboBox, new GridConstraints(3, 1, 1, 3, 0, 1, 2, 0, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("Storage:");
        jPanel.add((Component)jBLabel4, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(2, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myInternalStorageRadioButton = jBRadioButton2 = new JBRadioButton();
        jBRadioButton2.setSelected(true);
        jBRadioButton2.setText("Internal");
        jPanel.add((Component)jBRadioButton2, new GridConstraints(2, 1, 1, 1, 0, 0, 3, 0, null, null, null));
        this.myExternalStorageRadioButton = jBRadioButton = new JBRadioButton();
        jBRadioButton.setText("External");
        jPanel.add((Component)jBRadioButton, new GridConstraints(2, 2, 1, 1, 0, 0, 3, 0, null, null, null));
        jBLabel.setLabelFor((Component)comboBox3);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)jBRadioButton);
        buttonGroup.add((AbstractButton)jBRadioButton2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

