/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.sql;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.core.ResultLayout;
import org.jetbrains.dekaf.sql.ScriptumResource;
import org.jetbrains.dekaf.sql.ScriptumResourceFromJava;
import org.jetbrains.dekaf.sql.SqlCommand;
import org.jetbrains.dekaf.sql.SqlQuery;
import org.jetbrains.dekaf.sql.SqlScript;
import org.jetbrains.dekaf.sql.SqlScriptBuilder;
import org.jetbrains.dekaf.sql.TextFileFragment;
import org.jetbrains.dekaf.util.Strings;

public final class Scriptum {
    @NotNull
    private final ScriptumResource[] myResources;
    @Nullable
    private final String myDialect;
    private static final Pattern STRIP_SINGLE_STATEMENT_PATTERN = Pattern.compile("((\\;\\s*)+|(\\n\\/\\s*\\n?)+)$", 32);

    @NotNull
    public static Scriptum of(@NotNull Class clazz) {
        ClassLoader classLoader = clazz.getClassLoader();
        String className = clazz.getName();
        String path = className.replace('.', '/');
        String resourceName = path + ".sql";
        return Scriptum.of(classLoader, resourceName);
    }

    @NotNull
    public static Scriptum of(@NotNull Class clazz, @NotNull String name) {
        ClassLoader classLoader = clazz.getClassLoader();
        String packageName = clazz.getPackage().getName();
        String path = packageName.replace('.', '/');
        String fileName = name;
        if (!fileName.contains(".")) {
            fileName = fileName + ".sql";
        }
        String resourceName = path + '/' + fileName;
        return Scriptum.of(classLoader, resourceName);
    }

    @NotNull
    public static Scriptum dialectOf(@NotNull Class clazz, @Nullable String dialect) {
        String name2;
        boolean exist2;
        ClassLoader classLoader = clazz.getClassLoader();
        String className = clazz.getName();
        String path = className.replace('.', '/');
        ArrayList<ScriptumResourceFromJava> sr = new ArrayList<ScriptumResourceFromJava>(2);
        if (dialect != null) {
            boolean exist1;
            String name1 = path + '+' + dialect + ".sql";
            boolean bl = exist1 = classLoader.getResource(name1) != null;
            if (exist1) {
                ScriptumResourceFromJava r1 = new ScriptumResourceFromJava(classLoader, name1);
                sr.add(r1);
            }
        }
        boolean bl = exist2 = classLoader.getResource(name2 = path + ".sql") != null;
        if (exist2) {
            ScriptumResourceFromJava r2 = new ScriptumResourceFromJava(classLoader, name2);
            sr.add(r2);
        }
        if (sr.isEmpty()) {
            throw new IllegalArgumentException(String.format("Resources for class %s not found", className));
        }
        ScriptumResource[] resources = sr.toArray(new ScriptumResource[sr.size()]);
        return new Scriptum(resources, dialect);
    }

    @NotNull
    public static Scriptum dialectOf(@NotNull Scriptum parentScriptum, @Nullable String dialect) {
        if (Strings.eq(parentScriptum.myDialect, dialect)) {
            return parentScriptum;
        }
        return new Scriptum(parentScriptum.myResources, dialect);
    }

    @NotNull
    public static Scriptum of(ClassLoader classLoader, String resourceName) {
        boolean exists;
        ArrayList<ScriptumResourceFromJava> sr = new ArrayList<ScriptumResourceFromJava>(2);
        boolean bl = exists = classLoader.getResource(resourceName) != null;
        if (!exists) {
            throw new IllegalArgumentException(String.format("Resources for class %s not found", resourceName));
        }
        ScriptumResourceFromJava r2 = new ScriptumResourceFromJava(classLoader, resourceName);
        sr.add(r2);
        ScriptumResource[] resources = sr.toArray(new ScriptumResource[sr.size()]);
        return new Scriptum(resources, null);
    }

    private Scriptum(@NotNull ScriptumResource[] resources, @Nullable String dialect) {
        this.myResources = resources;
        this.myDialect = dialect;
    }

    @Nullable
    public final TextFileFragment findText(@NotNull String name) {
        String nameWithDialect = this.myDialect == null ? null : name + '+' + this.myDialect;
        for (int i = this.myResources.length - 1; i >= 0; --i) {
            TextFileFragment fragment;
            ScriptumResource r = this.myResources[i];
            if (nameWithDialect != null && (fragment = r.find(nameWithDialect)) != null) {
                return fragment;
            }
            fragment = r.find(name);
            if (fragment == null) continue;
            return fragment;
        }
        return null;
    }

    @NotNull
    public final TextFileFragment getText(@NotNull String name) throws ScriptNotFoundException {
        TextFileFragment fragment = this.findText(name);
        if (fragment != null) {
            return fragment;
        }
        StringBuilder b = new StringBuilder();
        b.append("No such script with name: ").append(name).append('\n');
        boolean was = false;
        for (ScriptumResource r : this.myResources) {
            for (String existentName : r.getExistentNames()) {
                if (!was) {
                    b.append("There are scripts: ");
                    was = true;
                } else {
                    b.append(", ");
                }
                b.append(existentName);
            }
        }
        if (!was) {
            b.append("There are no scripts at all");
        }
        throw new ScriptNotFoundException(b.toString());
    }

    @NotNull
    public final <S> SqlQuery<S> query(@NotNull String name, @NotNull ResultLayout<S> layout) {
        TextFileFragment fragment = this.getText(name);
        fragment = this.stripSingleStatement(fragment);
        SqlQuery<S> query = new SqlQuery<S>(fragment, layout);
        query.setDisplayName(fragment.getFragmentName());
        return query;
    }

    @NotNull
    public final SqlCommand command(@NotNull String name) {
        TextFileFragment fragment = this.getText(name);
        fragment = this.stripSingleStatement(fragment);
        return new SqlCommand(fragment);
    }

    @NotNull
    public final SqlScript script(@NotNull String name) {
        TextFileFragment fragment = this.getText(name);
        SqlScriptBuilder b = new SqlScriptBuilder();
        b.parse(fragment.text);
        return new SqlScript(b.build());
    }

    @NotNull
    private TextFileFragment stripSingleStatement(@NotNull TextFileFragment fragment) {
        Matcher m = STRIP_SINGLE_STATEMENT_PATTERN.matcher(fragment.text);
        if (m.find()) {
            int n = fragment.text.length();
            String text = Strings.rtrim(fragment.text.substring(0, n -= m.group(1).length()));
            return new TextFileFragment(text, fragment.getTextName(), fragment.row, fragment.pos, fragment.getFragmentName());
        }
        return fragment;
    }

    public static class ScriptNotFoundException
    extends RuntimeException {
        private ScriptNotFoundException(String message) {
            super(message);
        }
    }
}

