/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.jdbc;

import java.sql.Driver;
import java.util.Properties;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Oracle;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.exceptions.DBInitializationException;
import org.jetbrains.dekaf.exceptions.DBPreparingException;
import org.jetbrains.dekaf.jdbc.BaseExceptionRecognizer;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateRdbmsProvider;
import org.jetbrains.dekaf.jdbc.OracleExceptionRecognizer;
import org.jetbrains.dekaf.jdbc.OracleIntermediateFacade;

public class OracleIntermediateProvider
extends JdbcIntermediateRdbmsProvider {
    static final Pattern ORACLE_CONNECTION_STRING_PATTERN = Pattern.compile("^jdbc:oracle:(oci|thin):.*@.+$");
    static final String ORACLE_CONNECTION_STRING_EXAMPLE = "jdbc:oracle:thin:@//localhost:1521/XE";
    private static final String ORACLE_DRIVER_CLASS_NAME = "oracle.jdbc.driver.OracleDriver";

    @Override
    @NotNull
    protected String getConnectionStringExample() {
        return ORACLE_CONNECTION_STRING_EXAMPLE;
    }

    @Override
    protected Driver loadDriver() {
        Driver driver;
        Class<Driver> driverClass = this.getSimpleAccessibleDriverClass(ORACLE_DRIVER_CLASS_NAME);
        if (driverClass == null) {
            // empty if block
        }
        if (driverClass == null) {
            throw new DBInitializationException("Oracle Driver class not found");
        }
        try {
            driver = driverClass.newInstance();
        }
        catch (Exception e) {
            throw new DBPreparingException("Failed to instantiate driver: " + e.getMessage(), e);
        }
        return driver;
    }

    @Override
    @NotNull
    public Rdbms rdbms() {
        return Oracle.RDBMS;
    }

    @Override
    @NotNull
    public Pattern connectionStringPattern() {
        return ORACLE_CONNECTION_STRING_PATTERN;
    }

    @Override
    public byte specificity() {
        return 10;
    }

    @Override
    @NotNull
    protected OracleIntermediateFacade instantiateFacade(@NotNull String connectionString, @Nullable Properties connectionProperties, int connectionsLimit, @NotNull Driver driver) {
        return new OracleIntermediateFacade(connectionString, connectionProperties, driver, connectionsLimit, OracleExceptionRecognizer.INSTANCE);
    }

    @Override
    @NotNull
    public BaseExceptionRecognizer getExceptionRecognizer() {
        return OracleExceptionRecognizer.INSTANCE;
    }
}

