/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.jdbc;

import java.sql.Driver;
import java.util.Properties;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Mssql;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.exceptions.DBInitializationException;
import org.jetbrains.dekaf.exceptions.DBPreparingException;
import org.jetbrains.dekaf.jdbc.BaseExceptionRecognizer;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateRdbmsProvider;
import org.jetbrains.dekaf.jdbc.MssqlExceptionRecognizer;
import org.jetbrains.dekaf.jdbc.MssqlIntermediateFacade;

public class MssqlIntermediateProvider
extends JdbcIntermediateRdbmsProvider {
    public static final MssqlIntermediateProvider INSTANCE = new MssqlIntermediateProvider();
    static final Pattern MSSQL_CONNECTION_STRING_PATTERN = Pattern.compile("^jdbc:sqlserver:.+$");
    static final String MSSQL_CONNECTION_STRING_EXAMPLE = "jdbc:sqlserver://";
    private static final String MSSQL_DRIVER_CLASS_NAME = "com.microsoft.sqlserver.jdbc.SQLServerDriver";

    @Override
    @NotNull
    protected String getConnectionStringExample() {
        return MSSQL_CONNECTION_STRING_EXAMPLE;
    }

    @Override
    protected Driver loadDriver() {
        Driver driver;
        Class<Driver> driverClass = this.getSimpleAccessibleDriverClass(MSSQL_DRIVER_CLASS_NAME);
        if (driverClass == null) {
            // empty if block
        }
        if (driverClass == null) {
            throw new DBInitializationException("MS SQL Driver class not found");
        }
        try {
            driver = driverClass.newInstance();
        }
        catch (Exception e) {
            throw new DBPreparingException("Failed to instantiate driver: " + e.getMessage(), e);
        }
        return driver;
    }

    @Override
    @NotNull
    public Rdbms rdbms() {
        return Mssql.RDBMS;
    }

    @Override
    @NotNull
    public Pattern connectionStringPattern() {
        return MSSQL_CONNECTION_STRING_PATTERN;
    }

    @Override
    public byte specificity() {
        return 10;
    }

    @Override
    @NotNull
    protected MssqlIntermediateFacade instantiateFacade(@NotNull String connectionString, @Nullable Properties connectionProperties, int connectionsLimit, @NotNull Driver driver) {
        return new MssqlIntermediateFacade(connectionString, connectionProperties, driver, connectionsLimit, MssqlExceptionRecognizer.INSTANCE);
    }

    @Override
    @NotNull
    public BaseExceptionRecognizer getExceptionRecognizer() {
        return MssqlExceptionRecognizer.INSTANCE;
    }
}

