/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.intermediate;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dekaf.core.ResultLayout;
import org.jetbrains.dekaf.core.RowLayout;
import org.jetbrains.dekaf.exceptions.DBFetchingException;
import org.jetbrains.dekaf.intermediate.AdaptIntermediateCursor;
import org.jetbrains.dekaf.intermediate.PrimeIntermediateCursor;
import org.jetbrains.dekaf.util.Classes;
import org.jetbrains.dekaf.util.Collects;

public class AdaptIntermediateStructCollectingCursor<T>
extends AdaptIntermediateCursor<T, List<Object[]>> {
    @NotNull
    private ResultLayout<T> myResultLayout;
    @NotNull
    private final Constructor myRowConstructor;
    @NotNull
    private final Field[] myRowClassFields;
    private transient Collection myContainer;
    private boolean myHasRows;

    public AdaptIntermediateStructCollectingCursor(@NotNull PrimeIntermediateCursor<List<Object[]>> remoteCursor, @NotNull ResultLayout<T> resultLayout) {
        super(remoteCursor);
        assert (resultLayout.kind == ResultLayout.Kind.SINGLE_ROW || resultLayout.kind == ResultLayout.Kind.ARRAY || resultLayout.kind == ResultLayout.Kind.LIST || resultLayout.kind == ResultLayout.Kind.SET);
        assert (resultLayout.row.kind == RowLayout.Kind.STRUCT);
        Class rowClass = resultLayout.row.rowClass;
        this.myResultLayout = resultLayout;
        this.myRowConstructor = Classes.defaultConstructorOf(rowClass);
        this.myRowConstructor.setAccessible(true);
        Object[] components = this.myResultLayout.row.components;
        int n = components.length;
        this.myRowClassFields = new Field[n];
        this.myHasRows = remoteCursor.hasRows();
        if (!this.hasRows()) {
            return;
        }
        boolean somethingMatched = false;
        for (int i = 0; i < n; ++i) {
            String name = components[i].name;
            try {
                Field field = rowClass.getDeclaredField(name);
                field.setAccessible(true);
                this.myRowClassFields[i] = field;
                somethingMatched = true;
                continue;
            }
            catch (NoSuchFieldException e) {
                // empty catch block
            }
        }
        if (!somethingMatched) {
            String msg = String.format("The query result and the class %s have no common fields. Fields of the class: [%s].", rowClass.getName(), Collects.arrayToString(components, ", "));
            throw new IllegalStateException(msg);
        }
    }

    @Override
    public boolean hasRows() {
        return this.myHasRows && super.hasRows();
    }

    @Override
    public synchronized T fetch() {
        int n;
        List data;
        if (this.hasRows()) {
            data = (List)this.myRemoteCursor.fetch();
            n = data.size();
        } else {
            data = Collections.emptyList();
            n = 0;
        }
        this.prepareContainer(n);
        for (int i = 0; i < n; ++i) {
            Object row = this.makeRow((Object[])data.get(i));
            this.myContainer.add(row);
        }
        return this.completeCollection();
    }

    private void prepareContainer(int capacity) {
        switch (this.myResultLayout.kind) {
            case SINGLE_ROW: 
            case ARRAY: 
            case LIST: {
                this.myContainer = new ArrayList(capacity);
                break;
            }
            case SET: {
                this.myContainer = this.myResultLayout.sorted ? new TreeSet() : new HashSet(capacity);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown how to collect a " + (Object)((Object)this.myResultLayout.kind));
            }
        }
    }

    private Object makeRow(Object[] componentValues) {
        Object row;
        try {
            row = this.myRowConstructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new DBFetchingException(String.format("Failed to instantiate class %s: error %s: %s", this.myResultLayout.row.rowClass.getName(), e.getClass().getSimpleName(), e.getMessage()), e, null);
        }
        int n = this.myRowClassFields.length;
        for (int i = 0; i < n; ++i) {
            Field f = this.myRowClassFields[i];
            Object value = componentValues[i];
            if (value == null) continue;
            try {
                f.set(row, value);
                continue;
            }
            catch (IllegalAccessException e) {
                throw new DBFetchingException(String.format("Failed to assign field %s of class %s with a value of class %s: error %s: %s. The value: \"%s\"", f.getName(), row.getClass().getName(), value.getClass().getSimpleName(), e.getClass().getSimpleName(), e.getMessage(), value.toString()), e, null);
            }
        }
        return row;
    }

    private T completeCollection() {
        Object[] result;
        switch (this.myResultLayout.kind) {
            case SINGLE_ROW: {
                result = !this.myContainer.isEmpty() ? this.myContainer.iterator().next() : null;
                break;
            }
            case ARRAY: {
                int n = this.myContainer.size();
                Object[] array = (Object[])Array.newInstance(this.myResultLayout.row.rowClass, n);
                result = this.myContainer.toArray(array);
                break;
            }
            case LIST: {
                result = this.myContainer;
                break;
            }
            case SET: {
                result = this.myContainer;
                break;
            }
            default: {
                result = null;
                assert (false);
                break;
            }
        }
        return (T)result;
    }
}

