/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.views;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.paths.GlobalPathReferenceProvider;
import com.intellij.openapi.paths.WebReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiMethodPattern;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.jsp.WebDirectoryElement;
import com.intellij.spring.constants.SpringReferencePatternConditions;
import com.intellij.spring.web.mvc.SpringControllerClassInfo;
import com.intellij.spring.web.mvc.SpringMVCReference;
import com.intellij.spring.web.mvc.model.SpringMVCModel;
import com.intellij.spring.web.mvc.model.SpringMVCModelService;
import com.intellij.spring.web.mvc.views.UrlBasedViewResolver;
import com.intellij.spring.web.mvc.views.ViewReference;
import com.intellij.spring.web.mvc.views.ViewResolver;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SpringMVCViewReferenceProvider
extends PsiReferenceProvider {
    public static final PsiJavaElementPattern.Capture<PsiElement> VIEW_PATTERN = (PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement((Class[])new Class[]{PsiLiteral.class, PsiReferenceExpression.class}).with(SpringReferencePatternConditions.PROJECT_HAS_SPRING_FACETS_CONDITION)).andOr(new ElementPattern[]{PsiJavaPatterns.psiExpression().methodCallParameter(0, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("setViewName")).inClass((ElementPattern)PsiJavaPatterns.psiClass().withQualifiedName((ElementPattern)PsiJavaPatterns.string().oneOf(new String[]{"org.springframework.web.servlet.ModelAndView", "org.springframework.web.servlet.config.annotation.ViewControllerRegistration"})))), PsiJavaPatterns.psiExpression().constructorParameter(0, new String[]{"org.springframework.web.servlet.ModelAndView"}), PsiJavaPatterns.psiExpression().withParent((ElementPattern)PsiJavaPatterns.psiElement(PsiReturnStatement.class).inside((ElementPattern)PsiJavaPatterns.psiMethod().with((PatternCondition)new PatternCondition<PsiMethod>("mvcRequestHandler"){

        public boolean accepts(@NotNull PsiMethod method, ProcessingContext context) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/spring/web/mvc/views/SpringMVCViewReferenceProvider$1", "accepts"));
            }
            if (!SpringControllerClassInfo.isRequestHandlerCandidate(method)) {
                return false;
            }
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)"org.springframework.web.bind.annotation.ResponseBody", (boolean)false)) {
                return false;
            }
            PsiClass psiClass = method.getContainingClass();
            if (psiClass == null) {
                return false;
            }
            SpringControllerClassInfo controllerClassInfo = SpringControllerClassInfo.getInfo(psiClass);
            if (!controllerClassInfo.isRequestHandler(method)) {
                return false;
            }
            if (!SpringControllerClassInfo.isJamRequestHandler(method)) {
                return true;
            }
            return !controllerClassInfo.hasClassLevelResponseBody();
        }
    })))});
    private final boolean mySoft;

    public SpringMVCViewReferenceProvider() {
        this(true);
    }

    public SpringMVCViewReferenceProvider(boolean soft) {
        this.mySoft = soft;
    }

    public static void register(PsiReferenceRegistrar registrar) {
        registrar.registerReferenceProvider(VIEW_PATTERN, (PsiReferenceProvider)new SpringMVCViewReferenceProvider(false), 100.0);
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        PsiType type;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/web/mvc/views/SpringMVCViewReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/web/mvc/views/SpringMVCViewReferenceProvider", "getReferencesByElement"));
        }
        if (element instanceof PsiLiteralExpression && ((type = ((PsiLiteralExpression)element).getType()) == null || !type.equalsToText("java.lang.String"))) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/views/SpringMVCViewReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        SpringMVCModel model = SpringMVCModelService.getInstance().getModel(element);
        if (model == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/views/SpringMVCViewReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        TextRange range = ElementManipulators.getValueTextRange((PsiElement)element);
        String text = range.substring(element.getText());
        if (text.startsWith("redirect:")) {
            String redirectUrl = (range = SpringMVCViewReferenceProvider.adjustRange(range, text, "redirect:")).substring(element.getText());
            if (GlobalPathReferenceProvider.isWebReferenceUrl((String)redirectUrl)) {
                PsiReference[] psiReferenceArray = new PsiReference[]{new WebReference(element, range)};
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/views/SpringMVCViewReferenceProvider", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
            SpringMVCReference mvcReference = new SpringMVCReference(element, range.getStartOffset(), redirectUrl, model.getServletMappingInfo(), true);
            PsiReference[] psiReferenceArray = new PsiReference[]{mvcReference};
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/views/SpringMVCViewReferenceProvider", "getReferencesByElement"));
            }
            return psiReferenceArray;
        }
        range = SpringMVCViewReferenceProvider.adjustRange(range, text, "forward:");
        text = range.substring(element.getText());
        SmartList references = new SmartList();
        List allResolvers = model.getViewResolvers();
        final boolean soft = this.mySoft || model.hasUnknownResolvers();
        SmartList resolvers = new SmartList();
        for (final ViewResolver viewResolver : allResolvers) {
            WebDirectoryElement root;
            if (viewResolver instanceof UrlBasedViewResolver && (root = ((UrlBasedViewResolver)viewResolver).getRoot(model)) != null) {
                FileReferenceSet fileReferenceSet = new FileReferenceSet(text, element, range.getStartOffset(), null, false){

                    public FileReference createFileReference(TextRange range, int index, String text) {
                        return new FileReference(this, range, index, text){

                            protected String encode(String name, PsiElement psiElement) {
                                if (psiElement instanceof PsiFile) {
                                    name = ((UrlBasedViewResolver)viewResolver).encode(name);
                                }
                                return name == null ? null : super.encode(name, psiElement);
                            }

                            @NotNull
                            public String decode(@NotNull String name) {
                                if (name == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/spring/web/mvc/views/SpringMVCViewReferenceProvider$2$1", "decode"));
                                }
                                if (this.isLast()) {
                                    name = ((UrlBasedViewResolver)viewResolver).decode(name);
                                }
                                String string = super.decode(name);
                                if (string == null) {
                                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/views/SpringMVCViewReferenceProvider$2$1", "decode"));
                                }
                                return string;
                            }

                            public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
                                if (element == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/web/mvc/views/SpringMVCViewReferenceProvider$2$1", "bindToElement"));
                                }
                                String newName = viewResolver.bindToElement(element);
                                return newName == null ? this.getElement() : ElementManipulators.getManipulator((PsiElement)this.getElement()).handleContentChange(this.getElement(), newName);
                            }

                            public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
                                return super.handleElementRename(viewResolver.handleElementRename(newElementName));
                            }
                        };
                    }

                    protected boolean isUrlEncoded() {
                        return true;
                    }

                    protected boolean isSoft() {
                        return soft;
                    }
                };
                fileReferenceSet.addCustomization(FileReferenceSet.DEFAULT_PATH_EVALUATOR_OPTION, psiFile -> Collections.singletonList(root));
                references.addAll(Arrays.asList(fileReferenceSet.getAllReferences()));
                continue;
            }
            resolvers.add(viewResolver);
        }
        if (!resolvers.isEmpty() || allResolvers.isEmpty()) {
            references.add(new ViewReference(element, (List<ViewResolver>)resolvers, range, soft));
        }
        PsiReference[] psiReferenceArray = references.toArray(new PsiReference[references.size()]);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/views/SpringMVCViewReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }

    private static TextRange adjustRange(TextRange range, String text, String prefix) {
        return text.startsWith(prefix) ? new TextRange(range.getStartOffset() + prefix.length(), range.getEndOffset()) : range;
    }
}

