/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.views;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FilePathReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.web.mvc.model.SpringMVCModel;
import com.intellij.spring.web.mvc.views.ViewResolver;
import com.intellij.spring.web.mvc.views.ViewResolverFactory;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ResourceBundleViewResolverFactory
extends ViewResolverFactory {
    public String getBeanClass() {
        return "org.springframework.web.servlet.view.ResourceBundleViewResolver";
    }

    public Set<ViewResolver> doCreate(CommonSpringBean bean, SpringModel model) {
        return Collections.singleton(new ResourceBundleViewResolver(bean));
    }

    private static class ResourceBundleViewResolver
    extends ViewResolver {
        private final Set<String> myBasenames = ContainerUtil.newLinkedHashSet();
        private final CommonSpringBean myBean;

        private ResourceBundleViewResolver(CommonSpringBean commonSpringBean) {
            this.myBean = commonSpringBean;
            if (commonSpringBean instanceof SpringBean) {
                SpringBean bean = (SpringBean)commonSpringBean;
                String basename = SpringPropertyUtils.getPropertyStringValue((CommonSpringBean)bean, (String)"basename");
                if (basename != null) {
                    this.myBasenames.add(basename);
                } else {
                    Set basenames = SpringPropertyUtils.getArrayPropertyStringValues((CommonSpringBean)bean, (String)"basenames");
                    if (basenames.size() > 0) {
                        this.myBasenames.addAll(basenames);
                    } else {
                        this.myBasenames.add("views");
                    }
                }
            }
        }

        public PsiElement resolveView(String viewName, SpringMVCModel springMVCModel) {
            List<PropertiesFile> bundles = this.getBundles();
            for (PropertiesFile bundle : bundles) {
                IProperty property = bundle.findPropertyByKey(viewName);
                if (property == null) continue;
                return property.getPsiElement();
            }
            return null;
        }

        public List<LookupElement> getAllViews(SpringMVCModel context) {
            ArrayList<LookupElement> list = new ArrayList<LookupElement>();
            List<PropertiesFile> bundles = this.getBundles();
            for (PropertiesFile bundle : bundles) {
                for (IProperty property : bundle.getProperties()) {
                    String key = property.getKey();
                    if (key == null) continue;
                    list.add((LookupElement)LookupElementBuilder.create((String)key).withTailText(" (" + property.getValue() + ")", true));
                }
            }
            return list;
        }

        public String bindToElement(PsiElement element) {
            return ((IProperty)element).getKey();
        }

        @NotNull
        public String handleElementRename(String newElementName) {
            String string = newElementName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/views/ResourceBundleViewResolverFactory$ResourceBundleViewResolver", "handleElementRename"));
            }
            return string;
        }

        private List<PropertiesFile> getBundles() {
            PsiFile containingFile = this.myBean.getContainingFile();
            assert (containingFile != null);
            ArrayList<PropertiesFile> files = new ArrayList<PropertiesFile>();
            PsiFileFactory factory = PsiFileFactory.getInstance((Project)containingFile.getProject());
            for (String basename : this.myBasenames) {
                String text = basename + ".properties";
                PsiFileImpl file = (PsiFileImpl)factory.createFileFromText("foo.txt", text);
                file.setOriginalFile(containingFile);
                PsiReference[] references = new FilePathReferenceProvider().getReferencesByElement((PsiElement)file, text, 0, false);
                PsiFileSystemItem item = ((FileReference)references[0]).getFileReferenceSet().resolve();
                if (!(item instanceof PropertiesFile)) continue;
                files.add((PropertiesFile)item);
            }
            return files;
        }
    }
}

