/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.velocity;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.xml.mvc.VelocityConfigurer;
import com.intellij.spring.web.mvc.views.TemplateViewResolverFactory;
import com.intellij.spring.web.mvc.views.UrlBasedViewResolver;
import com.intellij.spring.web.mvc.views.ViewResolver;
import org.jetbrains.annotations.NotNull;

public class VelocityViewResolverFactory
extends TemplateViewResolverFactory {
    public VelocityViewResolverFactory() {
        super("org.springframework.web.servlet.view.velocity.VelocityViewResolver", "org.springframework.web.servlet.view.velocity.VelocityConfigurer", "resourceLoaderPath", ".vm");
    }

    @Override
    protected String getViewResolverRegistryMethodName() {
        return "velocity";
    }

    @Override
    @NotNull
    protected ViewResolver handleCustomConfigurer(CommonSpringBean configurer, UrlBasedViewResolver resolver) {
        if (configurer instanceof VelocityConfigurer) {
            VelocityConfigurer velocityConfigurer = (VelocityConfigurer)configurer;
            String resourceLoaderPath = velocityConfigurer.getResourceLoaderPath().getStringValue();
            UrlBasedViewResolver urlBasedViewResolver = new UrlBasedViewResolver(StringUtil.defaultIfEmpty((String)resourceLoaderPath, (String)"/WEB-INF/"), "");
            if (urlBasedViewResolver == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/velocity/VelocityViewResolverFactory", "handleCustomConfigurer"));
            }
            return urlBasedViewResolver;
        }
        ViewResolver viewResolver = super.handleCustomConfigurer(configurer, resolver);
        if (viewResolver == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/velocity/VelocityViewResolverFactory", "handleCustomConfigurer"));
        }
        return viewResolver;
    }
}

