/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.config.anno;

import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.model.jam.stereotype.SpringComponent;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.web.config.ServletFileSet;
import com.intellij.spring.web.config.SpringWebModelContributor;
import com.intellij.spring.web.config.anno.CodeConfigurationPropertiesParser;
import com.intellij.spring.web.config.anno.ServletContextServlet;
import com.intellij.spring.web.mvc.SpringMvcBundle;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AnnotationConfigSpringWebModelContributor
extends SpringWebModelContributor {
    private static final String ABSTRACT_ANNOTATION_INITIALIZER = "org.springframework.web.servlet.support.AbstractAnnotationConfigDispatcherServletInitializer";

    public Pair<List<SpringFileSet>, Object[]> getFilesets(@NotNull SpringFacet springFacet, @NotNull WebFacet webFacet) {
        if (springFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "springFacet", "com/intellij/spring/web/config/anno/AnnotationConfigSpringWebModelContributor", "getFilesets"));
        }
        if (webFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webFacet", "com/intellij/spring/web/config/anno/AnnotationConfigSpringWebModelContributor", "getFilesets"));
        }
        Module module = springFacet.getModule();
        PsiClass initializerClass = SpringCommonUtils.findLibraryClass((Module)module, (String)ABSTRACT_ANNOTATION_INITIALIZER);
        if (initializerClass == null) {
            return NO_RESULT;
        }
        SmartList additionalDependencies = new SmartList((Object)PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT);
        GlobalSearchScope inheritorsScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)false);
        Collection initializers = ClassInheritorsSearch.search((PsiClass)initializerClass, (SearchScope)inheritorsScope, (boolean)true).findAll();
        List fileSets = ContainerUtil.newSmartList();
        ContainerUtil.process((Iterable)initializers, arg_0 -> AnnotationConfigSpringWebModelContributor.lambda$getFilesets$0((List)additionalDependencies, module, springFacet, fileSets, arg_0));
        return Pair.create((Object)fileSets, (Object)ArrayUtil.toObjectArray((Collection)additionalDependencies));
    }

    private static boolean isConfigurationOrComponent(PsiClass psiClass) {
        return SpringCommonUtils.isConfigurationOrMeta((PsiClass)psiClass) || JamService.getJamService((Project)psiClass.getProject()).getJamElement((PsiElement)psiClass, new JamMemberMeta[]{SpringComponent.META}) != null;
    }

    private static /* synthetic */ boolean lambda$getFilesets$0(List additionalDependencies, Module module, @NotNull SpringFacet springFacet, List fileSets, PsiClass initializer) {
        if (springFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "springFacet", "com/intellij/spring/web/config/anno/AnnotationConfigSpringWebModelContributor", "lambda$getFilesets$0"));
        }
        additionalDependencies.add(initializer.getContainingFile());
        CodeConfigurationPropertiesParser parser = new CodeConfigurationPropertiesParser(initializer);
        String servletName = parser.getString("getServletName", true);
        if (StringUtil.isEmptyOrSpaces((String)servletName)) {
            return true;
        }
        PsiClass servletClass = SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.web.servlet.DispatcherServlet");
        PsiClass servletDefinitionElement = initializer;
        PsiElement mappingDefinitionElement = (PsiElement)ArrayUtil.getFirstElement((Object[])initializer.findMethodsByName("getServletMappings", false));
        String[] servletMappings = parser.getStringArray("getServletMappings", false);
        ServletContextServlet implicitServlet = new ServletContextServlet(servletName, servletClass, (PsiElement)servletDefinitionElement, mappingDefinitionElement, servletMappings);
        ServletFileSet initializerServletFileSet = new ServletFileSet("initializer " + initializer.getQualifiedName() + " servlet context", SpringMvcBundle.message("mvc.initializer.context.autodetected", servletName), implicitServlet, springFacet);
        List<PsiClass> servletConfigClasses = parser.getPsiClasses("getServletConfigClasses", false);
        boolean hasServletContext = !servletConfigClasses.isEmpty();
        for (PsiClass servletConfigClass : servletConfigClasses) {
            if (!AnnotationConfigSpringWebModelContributor.isConfigurationOrComponent(servletConfigClass)) continue;
            AnnotationConfigSpringWebModelContributor.addInFileset((SpringFileSet)initializerServletFileSet, (PsiFile)servletConfigClass.getContainingFile());
        }
        fileSets.add(initializerServletFileSet);
        ServletContextServlet rootContextImplicitServlet = hasServletContext ? null : implicitServlet;
        ServletFileSet rootContext = new ServletFileSet("initializer " + initializer.getQualifiedName() + " root context", "MVC " + servletName + " initializer root context", rootContextImplicitServlet, springFacet);
        for (PsiClass rootConfigClasses : parser.getPsiClasses("getRootConfigClasses", false)) {
            if (!AnnotationConfigSpringWebModelContributor.isConfigurationOrComponent(rootConfigClasses)) continue;
            AnnotationConfigSpringWebModelContributor.addInFileset((SpringFileSet)rootContext, (PsiFile)rootConfigClasses.getContainingFile());
        }
        initializerServletFileSet.addDependency((SpringFileSet)rootContext);
        fileSets.add(rootContext);
        return true;
    }
}

