/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider;

import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.Certificate;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.vfs2.FileChangeEvent;
import org.apache.commons.vfs2.FileContentInfo;
import org.apache.commons.vfs2.FileListener;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileNotFolderException;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.RandomAccessContent;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.util.RandomAccessMode;
import org.apache.commons.vfs2.util.WeakRefFileListener;

public class DelegateFileObject<AFS extends AbstractFileSystem>
extends AbstractFileObject<AFS>
implements FileListener {
    private FileObject file;
    private final Set<String> children = new HashSet<String>();
    private boolean ignoreEvent;

    public DelegateFileObject(AbstractFileName name, AFS fileSystem, FileObject file) throws FileSystemException {
        super(name, fileSystem);
        this.file = file;
        if (file != null) {
            WeakRefFileListener.installListener(file, this);
        }
    }

    public FileObject getDelegateFile() {
        return this.file;
    }

    public void attachChild(FileName baseName, FileType type) throws Exception {
        FileType oldType = this.doGetType();
        if (this.children.add(baseName.getBaseName())) {
            this.childrenChanged(baseName, type);
        }
        this.maybeTypeChanged(oldType);
    }

    public void setFile(FileObject file) throws Exception {
        FileType oldType = this.doGetType();
        if (file != null) {
            WeakRefFileListener.installListener(file, this);
        }
        this.file = file;
        this.maybeTypeChanged(oldType);
    }

    private void maybeTypeChanged(FileType oldType) throws Exception {
        FileType newType = this.doGetType();
        if (oldType == FileType.IMAGINARY && newType != FileType.IMAGINARY) {
            this.handleCreate(newType);
        } else if (oldType != FileType.IMAGINARY && newType == FileType.IMAGINARY) {
            this.handleDelete();
        }
    }

    @Override
    protected FileType doGetType() throws FileSystemException {
        if (this.file != null) {
            return this.file.getType();
        }
        if (this.children.size() > 0) {
            return FileType.FOLDER;
        }
        return FileType.IMAGINARY;
    }

    @Override
    protected boolean doIsReadable() throws FileSystemException {
        if (this.file != null) {
            return this.file.isReadable();
        }
        return true;
    }

    @Override
    protected boolean doIsWriteable() throws FileSystemException {
        if (this.file != null) {
            return this.file.isWriteable();
        }
        return false;
    }

    @Override
    protected boolean doIsExecutable() throws FileSystemException {
        if (this.file != null) {
            return this.file.isExecutable();
        }
        return false;
    }

    @Override
    protected boolean doIsHidden() throws FileSystemException {
        if (this.file != null) {
            return this.file.isHidden();
        }
        return false;
    }

    @Override
    protected String[] doListChildren() throws Exception {
        if (this.file != null) {
            FileObject[] children;
            try {
                children = this.file.getChildren();
            }
            catch (FileNotFolderException e) {
                throw new FileNotFolderException(this.getName(), (Throwable)e);
            }
            String[] childNames = new String[children.length];
            for (int i = 0; i < children.length; ++i) {
                childNames[i] = children[i].getName().getBaseName();
            }
            return childNames;
        }
        return this.children.toArray(new String[this.children.size()]);
    }

    @Override
    protected void doCreateFolder() throws Exception {
        this.ignoreEvent = true;
        try {
            this.file.createFolder();
        }
        finally {
            this.ignoreEvent = false;
        }
    }

    @Override
    protected void doDelete() throws Exception {
        this.ignoreEvent = true;
        try {
            this.file.delete();
        }
        finally {
            this.ignoreEvent = false;
        }
    }

    @Override
    protected long doGetContentSize() throws Exception {
        return this.file.getContent().getSize();
    }

    @Override
    protected Map<String, Object> doGetAttributes() throws Exception {
        return this.file.getContent().getAttributes();
    }

    @Override
    protected void doSetAttribute(String atttrName, Object value) throws Exception {
        this.file.getContent().setAttribute(atttrName, value);
    }

    @Override
    protected Certificate[] doGetCertificates() throws Exception {
        return this.file.getContent().getCertificates();
    }

    @Override
    protected long doGetLastModifiedTime(boolean accurate) throws Exception {
        return this.file.getContent().getLastModifiedTime(accurate);
    }

    @Override
    protected boolean doSetLastModifiedTime(long modtime) throws Exception {
        this.file.getContent().setLastModifiedTime(modtime);
        return true;
    }

    @Override
    protected InputStream doGetInputStream() throws Exception {
        return this.file.getContent().getInputStream();
    }

    @Override
    protected OutputStream doGetOutputStream(boolean bAppend) throws Exception {
        return this.file.getContent().getOutputStream(bAppend);
    }

    @Override
    public void fileCreated(FileChangeEvent event) throws Exception {
        if (event.getFile() != this.file) {
            return;
        }
        if (!this.ignoreEvent) {
            this.handleCreate(this.file.getType());
        }
    }

    @Override
    public void fileDeleted(FileChangeEvent event) throws Exception {
        if (event.getFile() != this.file) {
            return;
        }
        if (!this.ignoreEvent) {
            this.handleDelete();
        }
    }

    @Override
    public void fileChanged(FileChangeEvent event) throws Exception {
        if (event.getFile() != this.file) {
            return;
        }
        if (!this.ignoreEvent) {
            this.handleChanged();
        }
    }

    @Override
    public void close() throws FileSystemException {
        super.close();
        if (this.file != null) {
            this.file.close();
        }
    }

    @Override
    public void refresh() throws FileSystemException {
        super.refresh();
        if (this.file != null) {
            this.file.refresh();
        }
    }

    protected FileContentInfo doGetContentInfo() throws Exception {
        return this.file.getContent().getContentInfo();
    }

    @Override
    protected void doRename(FileObject newFile) throws Exception {
        this.file.moveTo(((DelegateFileObject)newFile).file);
    }

    @Override
    protected void doRemoveAttribute(String atttrName) throws Exception {
        this.file.getContent().removeAttribute(atttrName);
    }

    @Override
    protected RandomAccessContent doGetRandomAccessContent(RandomAccessMode mode) throws Exception {
        return this.file.getContent().getRandomAccessContent(mode);
    }
}

