/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.cloudfoundry.agent.base.cloud;

import com.intellij.javaee.cloudfoundry.agent.cloud.CFCloudAgent;
import com.intellij.javaee.cloudfoundry.agent.cloud.CFCloudAgentConfiguration;
import com.intellij.javaee.cloudfoundry.agent.wrappers.CFApplication;
import com.intellij.javaee.util.AgentServerInstancePoller;
import com.intellij.javaee.util.ILogger;
import com.intellij.remoteServer.agent.util.CloudAgentCallback;
import com.intellij.remoteServer.agent.util.CloudAgentErrorHandler;
import com.intellij.remoteServer.agent.util.CloudAgentLogger;
import com.intellij.remoteServer.agent.util.CloudRemoteApplication;
import java.net.MalformedURLException;
import java.util.List;
import org.springframework.web.client.RestClientException;

public abstract class CFCloudAgentBase
implements CFCloudAgent {
    private AgentServerInstancePoller myPoller;
    private CloudAgentLogger myLogger;
    private CloudAgentErrorHandler myErrorHandler;

    @Override
    public void connect(CFCloudAgentConfiguration config, CloudAgentCallback callback, CloudAgentLogger logger, CloudAgentErrorHandler errorHandler) {
        this.myLogger = logger;
        this.myErrorHandler = errorHandler;
        try {
            this.doConnect(config);
            this.startPoll();
            callback.connected();
        }
        catch (RestClientException e) {
            callback.errorOccurred(e.toString());
        }
        catch (MalformedURLException e) {
            callback.errorOccurred(e.toString());
        }
        catch (IllegalArgumentException e) {
            callback.errorOccurred(e.toString());
        }
        catch (IllegalStateException e) {
            callback.errorOccurred(e.toString());
        }
    }

    public void disconnect() {
        this.stopPoll();
    }

    private void startPoll() {
        this.myPoller = new AgentServerInstancePoller((ILogger)new LoggerWrapper());
        this.myPoller.onInstanceStart();
    }

    private void stopPoll() {
        this.myPoller.onInstanceShutdown();
    }

    public AgentServerInstancePoller getPoller() {
        return this.myPoller;
    }

    public CloudAgentLogger getLogger() {
        return this.myLogger;
    }

    public CloudRemoteApplication[] getApplications() {
        return (CloudRemoteApplication[])new ApiTask<CloudRemoteApplication[]>(){

            @Override
            protected CloudRemoteApplication[] doPerform() {
                List<CFApplication> result = CFCloudAgentBase.this.doGetApplications();
                return result.toArray(new CloudRemoteApplication[result.size()]);
            }
        }.perform();
    }

    protected abstract void doConnect(CFCloudAgentConfiguration var1) throws MalformedURLException;

    public abstract List<CFApplication> doGetApplications();

    protected abstract class ApiTask<T> {
        protected ApiTask() {
        }

        public T perform() {
            try {
                return this.doPerform();
            }
            catch (RestClientException ex) {
                CFCloudAgentBase.this.myErrorHandler.onError(ex.toString());
                return null;
            }
        }

        protected abstract T doPerform();
    }

    private class LoggerWrapper
    implements ILogger {
        private LoggerWrapper() {
        }

        public void debugEx(Exception e) {
            CFCloudAgentBase.this.myLogger.debugEx(e);
        }

        public void errorEx(Exception e) {
        }

        public void debug(String message) {
        }

        public void error(String message) {
        }

        public void info(String message) {
        }
    }
}

