/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.util;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.impl.source.xml.XmlAttributeImpl;
import com.intellij.psi.impl.source.xml.XmlTagImpl;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class NSDeclTracker
implements ModificationTracker {
    private static final Key<Integer> MOD_COUNT = Key.create((String)"MOD_COUNT");
    private final XmlTagImpl myRootTag;
    private final List<XmlAttribute> myNSDecls;
    private int myRootCount;
    private int myCount;

    public NSDeclTracker(XmlTag rootTag) {
        this.myRootTag = (XmlTagImpl)rootTag;
        this.myNSDecls = this.getNSDecls(false);
        this.myRootCount = this.myRootTag.getModificationCount();
        this.myCount = 0;
    }

    public long getModificationCount() {
        return this.myRootTag.getModificationCount() == this.myRootCount ? (long)this.myCount : this.queryCount();
    }

    private synchronized long queryCount() {
        for (XmlAttribute decl : this.myNSDecls) {
            if (!decl.isValid()) {
                return this.update();
            }
            Integer modCount = (Integer)decl.getUserData(MOD_COUNT);
            if (modCount == null || ((XmlAttributeImpl)decl).getModificationCount() == modCount.intValue()) continue;
            return this.update();
        }
        ArrayList<XmlAttribute> list = this.getNSDecls(false);
        if (!list.equals(this.myNSDecls)) {
            return this.update();
        }
        this.myRootCount = this.myRootTag.getModificationCount();
        return this.myCount;
    }

    private long update() {
        this.myNSDecls.clear();
        this.myNSDecls.addAll(this.getNSDecls(true));
        this.myRootCount = this.myRootTag.getModificationCount();
        return ++this.myCount;
    }

    private ArrayList<XmlAttribute> getNSDecls(boolean updateModCount) {
        ArrayList<XmlAttribute> list = new ArrayList<XmlAttribute>(Arrays.asList(this.myRootTag.getAttributes()));
        Iterator<XmlAttribute> it = list.iterator();
        while (it.hasNext()) {
            XmlAttribute attribute = it.next();
            if (!attribute.isNamespaceDeclaration()) {
                it.remove();
            }
            if (!updateModCount) continue;
            attribute.putUserData(MOD_COUNT, (Object)((XmlAttributeImpl)attribute).getModificationCount());
        }
        return list;
    }
}

