/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.refactoring;

import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.TextFieldWithHistory;
import java.text.MessageFormat;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.intellij.lang.xpath.psi.XPathExpression;
import org.intellij.lang.xpath.xslt.refactoring.BaseIntroduceForm;
import org.intellij.lang.xpath.xslt.refactoring.RefactoringOptions;
import org.intellij.lang.xpath.xslt.util.NameValidator;

public abstract class BaseIntroduceDialog
extends DialogWrapper
implements RefactoringOptions {
    protected final InputValidator myInputValidator;

    public BaseIntroduceDialog(Project project, NamesValidator validator) {
        super(project, false);
        this.myInputValidator = new NameValidator(project, validator);
    }

    @Override
    public boolean isCanceled() {
        return !this.isOK();
    }

    protected void doOKAction() {
        if (this.myInputValidator.canClose(this.getName())) {
            super.doOKAction();
        }
    }

    protected void init(XPathExpression expression, int numberOfExpressions, String title) {
        this.setModal(true);
        this.setTitle(title);
        JLabel jLabel = this.getTypeLabel();
        jLabel.setText(expression.getType().getName());
        JCheckBox jCheckBox = this.getReplaceAll();
        if (numberOfExpressions > 1) {
            jCheckBox.setText(MessageFormat.format(jCheckBox.getText(), String.valueOf(numberOfExpressions)));
        } else {
            jCheckBox.setVisible(false);
        }
        this.getNameField().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                BaseIntroduceDialog.this.getOKAction().setEnabled(BaseIntroduceDialog.this.myInputValidator.checkInput(BaseIntroduceDialog.this.getName()));
            }
        });
        this.getOKAction().setEnabled(false);
        this.init();
    }

    private JCheckBox getReplaceAll() {
        return this.getForm().myReplaceAll;
    }

    private JLabel getTypeLabel() {
        return this.getForm().myTypeLabel;
    }

    private TextFieldWithHistory getNameField() {
        return this.getForm().myNameField;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.getForm().myNameField;
    }

    @Override
    public String getName() {
        return this.getNameField().getText();
    }

    protected abstract BaseIntroduceForm getForm();
}

