/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.quickfix;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.macro.CompleteMacro;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import org.intellij.lang.xpath.xslt.XsltSupport;
import org.intellij.lang.xpath.xslt.psi.XsltParameter;
import org.intellij.lang.xpath.xslt.quickfix.AbstractFix;
import org.intellij.lang.xpath.xslt.refactoring.RefactoringUtil;
import org.jetbrains.annotations.NotNull;

public class AddWithParamFix
extends AbstractFix {
    protected XmlTag myTag;
    private final String myName;

    protected AddWithParamFix() {
        this.myName = null;
    }

    public AddWithParamFix(XsltParameter parameter, XmlTag tag) {
        this.myTag = tag;
        this.myName = parameter.getName();
    }

    @NotNull
    public String getText() {
        String string = "Add Argument for '" + this.myName + "'";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/quickfix/AddWithParamFix", "getText"));
        }
        return string;
    }

    @Override
    public boolean isAvailableImpl(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/lang/xpath/xslt/quickfix/AddWithParamFix", "isAvailableImpl"));
        }
        return this.myTag.isValid();
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    protected boolean requiresEditor() {
        return true;
    }

    public void invoke(final @NotNull Project project, final Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/lang/xpath/xslt/quickfix/AddWithParamFix", "invoke"));
        }
        RunResult result = new WriteAction<SmartPsiElementPointer<XmlTag>>(){

            protected void run(@NotNull Result<SmartPsiElementPointer<XmlTag>> result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/intellij/lang/xpath/xslt/quickfix/AddWithParamFix$1", "run"));
                }
                XmlTag withParamTag = RefactoringUtil.addWithParam(AddWithParamFix.this.myTag);
                withParamTag.setAttribute("name", AddWithParamFix.this.myName != null ? AddWithParamFix.this.myName : "dummy");
                withParamTag.setAttribute("select", "dummy");
                result.setResult((Object)SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer((PsiElement)withParamTag));
            }
        }.execute();
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
        Document doc = psiDocumentManager.getDocument(file);
        assert (doc != null);
        psiDocumentManager.doPostponedOperationsAndUnblockDocument(doc);
        XmlTag withParamTag = (XmlTag)((SmartPsiElementPointer)result.getResultObject()).getElement();
        assert (withParamTag != null);
        final TemplateBuilderImpl builder = new TemplateBuilderImpl((PsiElement)withParamTag);
        XmlAttribute selectAttr = withParamTag.getAttribute("select", null);
        assert (selectAttr != null);
        PsiElement dummy = XsltSupport.getAttValueToken(selectAttr);
        builder.replaceElement(dummy, (Expression)new MacroCallNode((Macro)new CompleteMacro()));
        if (this.myName == null) {
            XmlAttribute nameAttr = withParamTag.getAttribute("name", null);
            assert (nameAttr != null);
            dummy = XsltSupport.getAttValueToken(nameAttr);
            builder.replaceElement(dummy, (Expression)new MacroCallNode((Macro)new CompleteMacro()));
        }
        AddWithParamFix.moveTo(editor, withParamTag);
        new WriteAction(){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/intellij/lang/xpath/xslt/quickfix/AddWithParamFix$2", "run"));
                }
                PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
                TemplateManager mgr = TemplateManager.getInstance((Project)AddWithParamFix.this.myTag.getProject());
                mgr.startTemplate(editor, builder.buildInlineTemplate());
            }
        }.execute();
    }
}

