/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.psi.impl;

import com.intellij.psi.PsiElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.intellij.lang.xpath.psi.XPathElementVisitor;
import org.intellij.lang.xpath.psi.XPathExpression;
import org.intellij.lang.xpath.psi.XPathType;
import org.intellij.lang.xpath.psi.XPathVariableReference;
import org.intellij.lang.xpath.xslt.XsltSupport;
import org.intellij.lang.xpath.xslt.psi.XsltVariable;
import org.intellij.lang.xpath.xslt.psi.impl.XsltElementImpl;
import org.intellij.lang.xpath.xslt.util.QNameUtil;
import org.intellij.lang.xpath.xslt.util.XsltCodeInsightUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XsltVariableImpl
extends XsltElementImpl
implements XsltVariable {
    XsltVariableImpl(XmlTag target) {
        super(target);
    }

    public Icon getIcon(int i) {
        return PlatformIcons.VARIABLE_ICON;
    }

    @Override
    @NotNull
    public XPathType getType() {
        XPathVariableReference reference;
        XPathType declaredType = XsltCodeInsightUtil.getDeclaredType(this.getTag());
        if (declaredType != null) {
            XPathType xPathType = declaredType;
            if (xPathType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/psi/impl/XsltVariableImpl", "getType"));
            }
            return xPathType;
        }
        XmlAttribute attr = this.getTag().getAttribute("type", "urn:idea:xslt-plugin#extensions");
        if (attr != null) {
            XPathType xPathType = XPathType.fromString(attr.getValue());
            if (xPathType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/psi/impl/XsltVariableImpl", "getType"));
            }
            return xPathType;
        }
        XPathExpression value = this.getValue();
        if (value instanceof XPathVariableReference && (reference = (XPathVariableReference)value).resolve() == this) {
            XPathType xPathType = XPathType.UNKNOWN;
            if (xPathType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/psi/impl/XsltVariableImpl", "getType"));
            }
            return xPathType;
        }
        XPathType xPathType = value != null ? value.getType() : XPathType.UNKNOWN;
        if (xPathType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/psi/impl/XsltVariableImpl", "getType"));
        }
        return xPathType;
    }

    @Override
    @Nullable
    public XPathExpression getValue() {
        return XsltCodeInsightUtil.getXPathExpression(this, "select");
    }

    @NotNull
    public final SearchScope getUseScope() {
        SearchScope searchScope = XsltSupport.isTopLevelElement(this.getTag()) ? this.getDefaultUseScope() : this.getLocalUseScope();
        if (searchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/psi/impl/XsltVariableImpl", "getUseScope"));
        }
        return searchScope;
    }

    @NotNull
    protected SearchScope getLocalUseScope() {
        LocalSearchScope localSearchScope = new LocalSearchScope((PsiElement)this.getTag().getParentTag());
        if (localSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/psi/impl/XsltVariableImpl", "getLocalUseScope"));
        }
        return localSearchScope;
    }

    @NotNull
    protected SearchScope getDefaultUseScope() {
        SearchScope searchScope = super.getUseScope();
        if (searchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/psi/impl/XsltVariableImpl", "getDefaultUseScope"));
        }
        return searchScope;
    }

    public String toString() {
        return "XPathVariable(XSLT): " + this.getTag().getValue();
    }

    @Override
    public boolean isVoid() {
        String name = this.getName();
        return name != null && "type:void".equals(QNameUtil.createQName(name, (PsiElement)this.getTag()).getNamespaceURI());
    }

    @Override
    public void accept(@NotNull XPathElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/intellij/lang/xpath/xslt/psi/impl/XsltVariableImpl", "accept"));
        }
        visitor.visitXPathVariable(this);
    }
}

