/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.psi.impl;

import com.intellij.psi.PsiElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.CommonProcessors;
import com.intellij.util.PlatformIcons;
import com.intellij.util.Processor;
import javax.swing.Icon;
import org.intellij.lang.xpath.xslt.impl.XsltIncludeIndex;
import org.intellij.lang.xpath.xslt.psi.XsltElementFactory;
import org.intellij.lang.xpath.xslt.psi.XsltParameter;
import org.intellij.lang.xpath.xslt.psi.XsltTemplate;
import org.intellij.lang.xpath.xslt.psi.impl.XsltVariableImpl;
import org.intellij.lang.xpath.xslt.util.XsltCodeInsightUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XsltParameterImpl
extends XsltVariableImpl
implements XsltParameter {
    XsltParameterImpl(XmlTag attribute) {
        super(attribute);
    }

    @Override
    public Icon getIcon(int i) {
        return PlatformIcons.PARAMETER_ICON;
    }

    @Override
    public boolean hasDefault() {
        return this.getValue() != null || !this.getTag().isEmpty();
    }

    @Override
    public boolean isAbstract() {
        boolean b = "true".equals(this.getTag().getAttributeValue("abstract", "urn:idea:xslt-plugin#extensions"));
        if (!b) {
            XsltTemplate template = this.getTemplate();
            return template != null && template.isAbstract();
        }
        return b;
    }

    @Override
    @Nullable
    public XsltTemplate getTemplate() {
        return XsltCodeInsightUtil.getTemplate((PsiElement)this.getTag(), false);
    }

    @Override
    public String toString() {
        return "XsltParam: " + this.getName();
    }

    @Override
    @NotNull
    public SearchScope getLocalUseScope() {
        XmlTag tag = this.getTag();
        if (!tag.isValid()) {
            SearchScope searchScope = this.getDefaultUseScope();
            if (searchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/psi/impl/XsltParameterImpl", "getLocalUseScope"));
            }
            return searchScope;
        }
        XsltTemplate template = this.getTemplate();
        if (template == null) {
            SearchScope searchScope = this.getDefaultUseScope();
            if (searchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/psi/impl/XsltParameterImpl", "getLocalUseScope"));
            }
            return searchScope;
        }
        if (template.getName() == null) {
            SearchScope searchScope = this.getDefaultUseScope();
            if (searchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/psi/impl/XsltParameterImpl", "getLocalUseScope"));
            }
            return searchScope;
        }
        XmlFile file = (XmlFile)tag.getContainingFile();
        if (!XsltIncludeIndex.processBackwardDependencies(file, (Processor<XmlFile>)new CommonProcessors.FindFirstProcessor())) {
            SearchScope searchScope = this.getDefaultUseScope();
            if (searchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/psi/impl/XsltParameterImpl", "getLocalUseScope"));
            }
            return searchScope;
        }
        LocalSearchScope localSearchScope = new LocalSearchScope((PsiElement)file);
        if (localSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/psi/impl/XsltParameterImpl", "getLocalUseScope"));
        }
        return localSearchScope;
    }

    public static XsltParameter getInstance(@NotNull XmlTag target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/intellij/lang/xpath/xslt/psi/impl/XsltParameterImpl", "getInstance"));
        }
        return XsltElementFactory.getInstance().wrapElement(target, XsltParameter.class);
    }
}

