/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import org.intellij.lang.xpath.xslt.XsltSupport;
import org.jetbrains.annotations.NotNull;

public class ConvertIfToChooseIntention
implements IntentionAction {
    @NotNull
    public String getFamilyName() {
        if ("Convert if to choose" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/intentions/ConvertIfToChooseIntention", "getFamilyName"));
        }
        return "Convert if to choose";
    }

    @NotNull
    public String getText() {
        if ("Convert xsl:if to xsl:choose" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/intentions/ConvertIfToChooseIntention", "getText"));
        }
        return "Convert xsl:if to xsl:choose";
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/lang/xpath/xslt/intentions/ConvertIfToChooseIntention", "invoke"));
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        assert (element != null);
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
        assert (tag != null && tag.getLocalName().equals("if"));
        String test = tag.getAttributeValue("test");
        String body = tag.getValue().getText();
        XmlTag parentTag = tag.getParentTag();
        assert (parentTag != null);
        XmlTag chooseTag = parentTag.createChildTag("choose", "http://www.w3.org/1999/XSL/Transform", null, false);
        XmlTag whenTag = parentTag.createChildTag("when", "http://www.w3.org/1999/XSL/Transform", body, false);
        XmlTag otherwiseTag = parentTag.createChildTag("otherwise", "http://www.w3.org/1999/XSL/Transform", "\n\n", false);
        whenTag.setAttribute("test", test);
        chooseTag.add((PsiElement)whenTag);
        chooseTag.add((PsiElement)otherwiseTag);
        CodeStyleManager.getInstance((Project)tag.getManager().getProject()).reformat(tag.replace((PsiElement)chooseTag));
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/lang/xpath/xslt/intentions/ConvertIfToChooseIntention", "isAvailable"));
        }
        if (!XsltSupport.isXsltFile(file)) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        if (element == null) {
            return false;
        }
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
        if (tag == null || tag.getParentTag() == null) {
            return false;
        }
        if (!tag.getLocalName().equals("if") || !XsltSupport.isXsltTag(tag)) {
            return false;
        }
        if (tag.getAttributeValue("test") == null) {
            return false;
        }
        ASTNode node = tag.getNode();
        if (node == null) {
            return false;
        }
        ASTNode child = XmlChildRole.START_TAG_NAME_FINDER.findChild(node);
        return child != null && child.getTextRange().contains(offset);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

