/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.associations.impl;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import icons.XpathIcons;
import org.intellij.lang.xpath.xslt.XsltSupport;
import org.intellij.lang.xpath.xslt.associations.FileAssociationsManager;
import org.intellij.lang.xpath.xslt.associations.impl.AddAssociationAction;
import org.intellij.lang.xpath.xslt.associations.impl.ConfigureAssociationsAction;
import org.intellij.lang.xpath.xslt.associations.impl.ToggleAssociationAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AssociationsGroup
extends ActionGroup {
    public AssociationsGroup() {
        this.getTemplatePresentation().setIcon(XpathIcons.Association);
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        AnAction[] children;
        if (!AssociationsGroup.isEnabled(e)) {
            if (AnAction.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/associations/impl/AssociationsGroup", "getChildren"));
            }
            return AnAction.EMPTY_ARRAY;
        }
        Project project = AssociationsGroup.getEventProject((AnActionEvent)e);
        if (project == null) {
            if (AnAction.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/associations/impl/AssociationsGroup", "getChildren"));
            }
            return AnAction.EMPTY_ARRAY;
        }
        PsiFile psiFile = AssociationsGroup.getPsiFile(e);
        if (psiFile == null) {
            if (AnAction.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/associations/impl/AssociationsGroup", "getChildren"));
            }
            return AnAction.EMPTY_ARRAY;
        }
        FileAssociationsManager fileAssociationsManager = FileAssociationsManager.getInstance(project);
        PsiFile[] associationsFor = fileAssociationsManager.getAssociationsFor(psiFile, FileAssociationsManager.Holder.XML_FILES);
        if (associationsFor.length == 0) {
            children = new AnAction[2];
        } else {
            children = new AnAction[associationsFor.length + 3];
            for (int i = 0; i < associationsFor.length; ++i) {
                PsiFile assoc = associationsFor[i];
                children[i] = new ToggleAssociationAction(fileAssociationsManager, psiFile, assoc);
            }
            children[children.length - 3] = Separator.getInstance();
        }
        children[children.length - 2] = new AddAssociationAction(fileAssociationsManager);
        children[children.length - 1] = new ConfigureAssociationsAction();
        if (children == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/associations/impl/AssociationsGroup", "getChildren"));
        }
        return children;
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setVisible(AssociationsGroup.isVisible(e));
        e.getPresentation().setEnabled(AssociationsGroup.isEnabled(e));
    }

    private static boolean isEnabled(@Nullable AnActionEvent e) {
        if (e == null) {
            return false;
        }
        PsiFile psiFile = AssociationsGroup.getPsiFile(e);
        if (psiFile == null) {
            return false;
        }
        if (!XsltSupport.isXsltFile(psiFile)) {
            return false;
        }
        Project project = AssociationsGroup.getEventProject((AnActionEvent)e);
        if (project == null) {
            return false;
        }
        return PsiManager.getInstance((Project)project).isInProject((PsiElement)psiFile);
    }

    private static boolean isVisible(AnActionEvent e) {
        PsiFile psiFile = AssociationsGroup.getPsiFile(e);
        if (psiFile == null) {
            return false;
        }
        return XsltSupport.isXsltFile(psiFile);
    }

    @Nullable
    static PsiFile getPsiFile(@Nullable AnActionEvent e) {
        return e != null ? (PsiFile)CommonDataKeys.PSI_FILE.getData(e.getDataContext()) : null;
    }
}

