/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.el.contextProviders.extensions;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiVariable;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.el.SpringBeansAsElVariableUtil;
import com.intellij.spring.el.contextProviders.SpringElContextsExtension;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringELContextVariablesExtension
extends SpringElContextsExtension {
    @NotNull
    public Collection<? extends PsiVariable> getContextVariables(@NotNull PsiElement contextElement) {
        if (contextElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextElement", "com/intellij/spring/el/contextProviders/extensions/SpringELContextVariablesExtension", "getContextVariables"));
        }
        List variables = ContainerUtil.newSmartList();
        SpringBeansAsElVariableUtil.addVariables((List<PsiVariable>)variables, SpringELContextVariablesExtension.getModel(contextElement));
        List list = variables;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/el/contextProviders/extensions/SpringELContextVariablesExtension", "getContextVariables"));
        }
        return list;
    }

    @Nullable
    public PsiVariable findContextVariable(@NotNull PsiElement contextElement, @NotNull String nameHint) {
        if (contextElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextElement", "com/intellij/spring/el/contextProviders/extensions/SpringELContextVariablesExtension", "findContextVariable"));
        }
        if (nameHint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameHint", "com/intellij/spring/el/contextProviders/extensions/SpringELContextVariablesExtension", "findContextVariable"));
        }
        SpringBeanPointer bean = SpringModelSearchers.findBean((CommonSpringModel)SpringELContextVariablesExtension.getModel(contextElement), (String)nameHint);
        return bean != null ? SpringBeansAsElVariableUtil.createVariable(bean, nameHint) : null;
    }

    @NotNull
    private static CommonSpringModel getModel(@NotNull PsiElement contextElement) {
        if (contextElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextElement", "com/intellij/spring/el/contextProviders/extensions/SpringELContextVariablesExtension", "getModel"));
        }
        CommonSpringModel commonSpringModel = SpringModelUtils.getInstance().getSpringModel(contextElement);
        if (commonSpringModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/el/contextProviders/extensions/SpringELContextVariablesExtension", "getModel"));
        }
        return commonSpringModel;
    }
}

