/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.el.completion;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.AddSpaceInsertHandler;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.jsp.el.ELBinaryExpression;
import com.intellij.psi.jsp.el.ELTokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spring.el.psi.SpringELExpression;
import com.intellij.spring.el.psi.SpringELExpressionHolder;
import com.intellij.spring.el.psi.SpringELLiteralExpression;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

public class SpringELKeywordCompletionContributor
extends CompletionContributor
implements DumbAware {
    private static final PsiElementPattern.Capture<PsiElement> SPEL_EXPRESSION_CAPTURE = (PsiElementPattern.Capture)PlatformPatterns.psiElement().inside(SpringELExpressionHolder.class);
    private static final PsiElementPattern.Capture<PsiElement> AFTER_DOT_AT_HASH_CAPTURE = (PsiElementPattern.Capture)PlatformPatterns.psiElement().afterLeaf(new String[]{".", "@", "#"});
    private static final PsiElementPattern.Capture<PsiElement> WITH_PRECEDING_WHITESPACE = (PsiElementPattern.Capture)PlatformPatterns.psiElement().with((PatternCondition)new PatternCondition<PsiElement>("withPrecedingWhitespace"){

        public boolean accepts(@NotNull PsiElement element, ProcessingContext context) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/el/completion/SpringELKeywordCompletionContributor$1", "accepts"));
            }
            PsiElement parent = element.getParent();
            return parent.getPrevSibling() instanceof PsiWhiteSpace;
        }
    });
    private static final PsiElementPattern.Capture<PsiElement> EMPTY_OR_START_OF_NEW_EXPRESSION = (PsiElementPattern.Capture)PlatformPatterns.psiElement().with((PatternCondition)new PatternCondition<PsiElement>("emptyExpression"){

        public boolean accepts(@NotNull PsiElement element, ProcessingContext context) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/el/completion/SpringELKeywordCompletionContributor$2", "accepts"));
            }
            PsiElement parent = element.getParent();
            if (parent instanceof SpringELLiteralExpression) {
                return false;
            }
            PsiElement prevSibling = parent.getPrevSibling();
            if (prevSibling == null) {
                return true;
            }
            IElementType elementType = prevSibling.getNode().getElementType();
            return elementType == ELTokenType.JSF_EL_START || elementType == ELTokenType.JSP_EL_LPARENTH || elementType == ELTokenType.JSP_EL_COMMA;
        }
    });
    private static final TailType PARENTHESES_WITH_AUTO_POPUP = new TailType(){

        public int processTail(Editor editor, int tailOffset) {
            tailOffset = 3.insertChar((Editor)editor, (int)tailOffset, (char)'(', (boolean)false);
            tailOffset = 3.insertChar((Editor)editor, (int)tailOffset, (char)')', (boolean)false);
            AutoPopupController.getInstance((Project)editor.getProject()).scheduleAutoPopup(editor);
            return 3.moveCaret((Editor)editor, (int)tailOffset, (int)-1);
        }
    };

    public SpringELKeywordCompletionContributor() {
        this.registerKeywordsAllPositions(SpringELKeywordCompletionContributor.provider("true", "false", "null"));
        this.registerKeywordsAllPositions(new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/spring/el/completion/SpringELKeywordCompletionContributor$4", "addCompletions"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/spring/el/completion/SpringELKeywordCompletionContributor$4", "addCompletions"));
                }
                result.addElement((LookupElement)LookupElementBuilder.create((String)"new").bold().withInsertHandler(AddSpaceInsertHandler.INSTANCE_WITH_AUTO_POPUP));
            }
        });
        this.registerKeywordsAllPositions(new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/spring/el/completion/SpringELKeywordCompletionContributor$5", "addCompletions"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/spring/el/completion/SpringELKeywordCompletionContributor$5", "addCompletions"));
                }
                LookupElementBuilder builder = LookupElementBuilder.create((String)"T").bold().withTailText("(...)", true);
                result.addElement((LookupElement)TailTypeDecorator.withTail((LookupElement)builder, (TailType)PARENTHESES_WITH_AUTO_POPUP));
            }
        });
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().and(WITH_PRECEDING_WHITESPACE)).with((PatternCondition)new PatternCondition<PsiElement>("afterExpression"){

            public boolean accepts(@NotNull PsiElement element, ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/el/completion/SpringELKeywordCompletionContributor$6", "accepts"));
                }
                PsiElement prev = element.getParent();
                return PsiTreeUtil.getPrevSiblingOfType((PsiElement)prev, SpringELExpression.class) != null;
            }
        })).andNot((ElementPattern)PlatformPatterns.psiElement().inside(ELBinaryExpression.class))).andNot(AFTER_DOT_AT_HASH_CAPTURE), SpringELKeywordCompletionContributor.provider("and", "or", "not", "eq", "ne", "lt", "gt", "le", "ge", "instanceof", "div", "mod", "between", "matches"));
    }

    private void registerKeywordsAllPositions(CompletionProvider<CompletionParameters> provider) {
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)SPEL_EXPRESSION_CAPTURE.andNot(AFTER_DOT_AT_HASH_CAPTURE)).andOr(new ElementPattern[]{WITH_PRECEDING_WHITESPACE, EMPTY_OR_START_OF_NEW_EXPRESSION}), provider);
    }

    private static CompletionProvider<CompletionParameters> provider(final String ... keywords) {
        if (keywords == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keywords", "com/intellij/spring/el/completion/SpringELKeywordCompletionContributor", "provider"));
        }
        return new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/spring/el/completion/SpringELKeywordCompletionContributor$7", "addCompletions"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/spring/el/completion/SpringELKeywordCompletionContributor$7", "addCompletions"));
                }
                for (String keyword : keywords) {
                    result.addElement((LookupElement)LookupElementBuilder.create((String)keyword).bold().withInsertHandler(AddSpaceInsertHandler.INSTANCE));
                }
            }
        };
    }
}

