/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.log;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgRevisionNumber;
import org.zmlx.hg4idea.util.HgUtil;
import org.zmlx.hg4idea.util.HgVersion;

public abstract class HgBaseLogParser<CommitT>
implements Function<String, CommitT> {
    private static final Logger LOG = Logger.getInstance(HgBaseLogParser.class);
    private static final int REVISION_INDEX = 0;
    private static final int CHANGESET_INDEX = 1;
    private static final int PARENTS_INDEX = 2;
    private static final int DATE_INDEX = 3;
    private static final int AUTHOR_INDEX = 4;
    protected static final int MESSAGE_INDEX = 5;
    protected static final int BRANCH_INDEX = 6;
    protected static final int FILES_ADDED_INDEX = 7;
    protected static final int FILES_MODIFIED_INDEX = 8;
    protected static final int FILES_DELETED_INDEX = 9;
    protected static final int FILES_COPIED_INDEX = 10;

    @Nullable
    public CommitT convert(@NotNull String line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "org/zmlx/hg4idea/log/HgBaseLogParser", "convert"));
        }
        List attributes = StringUtil.split((String)line, (String)"\u0017", (boolean)true, (boolean)false);
        int numAttributes = attributes.size();
        if (numAttributes <= 4) {
            LOG.info("Hg Log Command was cancelled or failed");
            return null;
        }
        try {
            String revisionString = (String)attributes.get(0);
            String changeset = (String)attributes.get(1);
            String parentsString = (String)attributes.get(2);
            SmartList<HgRevisionNumber> parents = HgBaseLogParser.parseParentRevisions(parentsString, revisionString);
            String unixTimeStamp = (String)ContainerUtil.getFirstItem((List)StringUtil.split((String)((String)attributes.get(3)), (String)" "));
            if (unixTimeStamp == null) {
                LOG.warn("Error parsing date in line " + line);
                return null;
            }
            Date revisionDate = new Date(Long.parseLong(unixTimeStamp.trim()) * 1000L);
            Couple<String> authorAndEmail = HgUtil.parseUserNameAndEmail((String)attributes.get(4));
            return this.convertDetails(revisionString, changeset, parents, revisionDate, (String)authorAndEmail.first, (String)authorAndEmail.second, attributes);
        }
        catch (NumberFormatException e) {
            LOG.warn("Error parsing rev in line " + line);
            return null;
        }
    }

    public CommitT fun(String s) {
        return this.convert(s);
    }

    @Nullable
    protected abstract CommitT convertDetails(@NotNull String var1, @NotNull String var2, @NotNull SmartList<HgRevisionNumber> var3, @NotNull Date var4, @NotNull String var5, @NotNull String var6, @NotNull List<String> var7);

    @NotNull
    public static List<String> constructDefaultTemplate(HgVersion currentVersion) {
        ArrayList<String> templates = new ArrayList<String>();
        templates.add("{rev}");
        templates.add("{node}");
        if (currentVersion.isParentRevisionTemplateSupported()) {
            templates.add("{p1rev}:{p1node} {p2rev}:{p2node}");
        } else {
            templates.add("{parents}");
        }
        templates.addAll(Arrays.asList("{date|hgdate}", "{author}"));
        ArrayList<String> arrayList = templates;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/log/HgBaseLogParser", "constructDefaultTemplate"));
        }
        return arrayList;
    }

    @NotNull
    public static String[] constructFullTemplateArgument(boolean includeFiles, @NotNull HgVersion currentVersion) {
        if (currentVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentVersion", "org/zmlx/hg4idea/log/HgBaseLogParser", "constructFullTemplateArgument"));
        }
        ArrayList<String> templates = new ArrayList<String>();
        templates.add("{rev}");
        templates.add("{node}");
        if (currentVersion.isParentRevisionTemplateSupported()) {
            templates.add("{p1rev}:{p1node} {p2rev}:{p2node}");
        } else {
            templates.add("{parents}");
        }
        templates.addAll(Arrays.asList("{date|hgdate}", "{author}", "{desc}", "{branch}"));
        if (!includeFiles) {
            String[] stringArray = ArrayUtil.toStringArray(templates);
            if (stringArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/log/HgBaseLogParser", "constructFullTemplateArgument"));
            }
            return stringArray;
        }
        ArrayList fileTemplates = ContainerUtil.newArrayList((Object[])new String[]{"file_adds", "file_mods", "file_dels", "file_copies"});
        templates.addAll(HgBaseLogParser.wrapIn(fileTemplates, currentVersion));
        String[] stringArray = ArrayUtil.toStringArray(templates);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/log/HgBaseLogParser", "constructFullTemplateArgument"));
        }
        return stringArray;
    }

    @NotNull
    private static List<String> wrapIn(@NotNull List<String> fileTemplates, @NotNull HgVersion currentVersion) {
        if (fileTemplates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileTemplates", "org/zmlx/hg4idea/log/HgBaseLogParser", "wrapIn"));
        }
        if (currentVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentVersion", "org/zmlx/hg4idea/log/HgBaseLogParser", "wrapIn"));
        }
        boolean supported = currentVersion.isBuiltInFunctionSupported();
        List list = ContainerUtil.map(fileTemplates, s -> supported ? "{join(" + s + ",'" + "\u0001" + "')}" : "{" + s + "}");
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/log/HgBaseLogParser", "wrapIn"));
        }
        return list;
    }

    @NotNull
    protected static SmartList<HgRevisionNumber> parseParentRevisions(@NotNull String parentsString, @NotNull String currentRevisionString) {
        if (parentsString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentsString", "org/zmlx/hg4idea/log/HgBaseLogParser", "parseParentRevisions"));
        }
        if (currentRevisionString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentRevisionString", "org/zmlx/hg4idea/log/HgBaseLogParser", "parseParentRevisions"));
        }
        SmartList parents = new SmartList();
        if (StringUtil.isEmptyOrSpaces((String)parentsString)) {
            Long revision = Long.valueOf(currentRevisionString);
            HgRevisionNumber parentRevision = HgRevisionNumber.getLocalInstance(String.valueOf(revision - 1L));
            parents.add((Object)parentRevision);
            SmartList smartList = parents;
            if (smartList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/log/HgBaseLogParser", "parseParentRevisions"));
            }
            return smartList;
        }
        List parentStrings = StringUtil.split((String)parentsString.trim(), (String)" ");
        for (String parentString : parentStrings) {
            List parentParts = StringUtil.split((String)parentString, (String)":");
            if (Integer.valueOf((String)parentParts.get(0)) < 0) continue;
            parents.add((Object)HgRevisionNumber.getInstance((String)parentParts.get(0), (String)parentParts.get(1)));
        }
        SmartList smartList = parents;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/log/HgBaseLogParser", "parseParentRevisions"));
        }
        return smartList;
    }

    @NotNull
    protected static String parseAdditionalStringAttribute(List<String> attributes, int index) {
        int numAttributes = attributes.size();
        if (numAttributes > index) {
            String string = attributes.get(index);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/log/HgBaseLogParser", "parseAdditionalStringAttribute"));
            }
            return string;
        }
        LOG.warn("Couldn't parse hg log commit info attribute " + index);
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/log/HgBaseLogParser", "parseAdditionalStringAttribute"));
        }
        return "";
    }

    @NotNull
    public static String extractSubject(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/zmlx/hg4idea/log/HgBaseLogParser", "extractSubject"));
        }
        int subjectIndex = message.indexOf(10);
        String string = subjectIndex == -1 ? message : message.substring(0, subjectIndex);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/log/HgBaseLogParser", "extractSubject"));
        }
        return string;
    }
}

