/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.glassfish.server;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.javaee.oss.glassfish.server.GlassfishDomainConfig;
import com.intellij.javaee.oss.glassfish.server.GlassfishJavaConfigProcessor;
import com.intellij.javaee.oss.glassfish.server.GlassfishLocalModel;
import com.intellij.javaee.run.localRun.ExecutableObject;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;

public class GlassfishExecutableWrapperBase
implements ExecutableObject {
    private static final Logger LOG = Logger.getInstance((String)("#" + GlassfishExecutableWrapperBase.class.getName()));
    @NonNls
    private static final String DEFAULT_OPTIONS_FILENAME = "domain.jvm-options-IDEA.xml";
    private final ExecutableObject myWrapped;
    private final GlassfishLocalModel myServerModel;

    public GlassfishExecutableWrapperBase(ExecutableObject wrapped, GlassfishLocalModel serverModel) {
        this.myWrapped = wrapped;
        this.myServerModel = serverModel;
    }

    public String getDisplayString() {
        return this.myWrapped.getDisplayString();
    }

    public OSProcessHandler createProcessHandler(String workingDirectory, Map<String, String> envVariables) throws ExecutionException {
        return this.myWrapped.createProcessHandler(workingDirectory, envVariables);
    }

    protected GlassfishLocalModel getServerModel() {
        return this.myServerModel;
    }

    protected static class DefaultOptionsReader {
        private final boolean myExists;
        private final Element myElement;
        private File myFile;

        public DefaultOptionsReader(File configFile) throws JDOMException, IOException {
            this.myFile = new File(configFile.getParent(), GlassfishExecutableWrapperBase.DEFAULT_OPTIONS_FILENAME);
            if (this.myFile.exists()) {
                this.myExists = true;
                this.myElement = JDOMUtil.load((File)this.myFile);
            } else {
                this.myExists = false;
                this.myElement = null;
            }
        }

        public boolean isExists() {
            return this.myExists;
        }

        public File getFile() {
            return this.myFile;
        }

        public Element getElement() {
            return this.myElement;
        }

        public void resetContent(Element optionsElement) {
            optionsElement.setContent((Collection)this.myElement.cloneContent());
            LOG.assertTrue(this.myFile.delete());
        }
    }

    protected abstract class GlassfishJavaConfigProcessorBase
    extends GlassfishJavaConfigProcessor {
        public GlassfishJavaConfigProcessorBase() {
            super(new GlassfishDomainConfig(GlassfishExecutableWrapperBase.this.myServerModel));
        }
    }
}

