/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.glassfish.editor.security;

import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.TreeExpander;
import com.intellij.javaee.model.xml.application.JavaeeApplication;
import com.intellij.javaee.model.xml.ejb.EjbJar;
import com.intellij.javaee.model.xml.web.WebApp;
import com.intellij.javaee.module.view.common.attributes.JavaeeTreeTableView;
import com.intellij.javaee.module.view.nodes.JavaeeNodeDescriptor;
import com.intellij.javaee.oss.glassfish.GlassfishBundle;
import com.intellij.javaee.oss.glassfish.editor.security.GlassfishAddAction;
import com.intellij.javaee.oss.glassfish.editor.security.GlassfishPrincipalColumn;
import com.intellij.javaee.oss.glassfish.editor.security.GlassfishRemoveAction;
import com.intellij.javaee.oss.glassfish.editor.security.GlassfishSecurityRoleWrapper;
import com.intellij.javaee.oss.glassfish.editor.security.GlassfishSecurityRolesNode;
import com.intellij.javaee.oss.glassfish.model.GlassfishSecurityRoleHolder;
import com.intellij.javaee.oss.util.TableSourceAction;
import com.intellij.javaee.oss.util.TreeExpanderImpl;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.ui.ColumnInfo;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GlassfishSecurityRolesEditor
extends JavaeeTreeTableView {
    private final GlassfishSecurityRoleWrapper wrapper;
    private final GlassfishSecurityRoleHolder holder;

    public static GlassfishSecurityRolesEditor get(JavaeeApplication app, GlassfishSecurityRoleHolder holder) {
        return new GlassfishSecurityRolesEditor(GlassfishSecurityRoleWrapper.get(app), holder);
    }

    public static GlassfishSecurityRolesEditor get(EjbJar ejb, GlassfishSecurityRoleHolder holder) {
        return new GlassfishSecurityRolesEditor(GlassfishSecurityRoleWrapper.get(ejb), holder);
    }

    public static GlassfishSecurityRolesEditor get(WebApp web, GlassfishSecurityRoleHolder holder) {
        return new GlassfishSecurityRolesEditor(GlassfishSecurityRoleWrapper.get(web), holder);
    }

    GlassfishSecurityRolesEditor(GlassfishSecurityRoleWrapper wrapper, GlassfishSecurityRoleHolder holder) {
        super(holder.getManager().getProject(), (JavaeeNodeDescriptor)new GlassfishSecurityRolesNode(wrapper, holder));
        this.wrapper = wrapper;
        this.holder = holder;
        this.getComponent().setBorder((Border)IdeBorderFactory.createTitledBorder((String)GlassfishBundle.getText("GlassfishSecurityRolesEditor.title", new Object[0]), (boolean)true));
        this.init();
    }

    protected boolean isShowTree() {
        return !this.wrapper.getSecurityRoles().isEmpty();
    }

    @NotNull
    protected String getEmptyPaneText() {
        String string = GlassfishBundle.getText("GlassfishSecurityRolesEditor.empty", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/oss/glassfish/editor/security/GlassfishSecurityRolesEditor", "getEmptyPaneText"));
        }
        return string;
    }

    protected ColumnInfo<?, ?>[] createColumnInfos() {
        return new ColumnInfo[]{new GlassfishPrincipalColumn(this.getProject())};
    }

    @Nullable
    protected ActionGroup createToolbarActions() {
        DefaultActionGroup actions = new DefaultActionGroup();
        actions.add((AnAction)new GlassfishAddAction(this.holder, this));
        actions.add((AnAction)new GlassfishRemoveAction(this));
        actions.addSeparator();
        actions.add(CommonActionsManager.getInstance().createExpandAllAction((TreeExpander)new TreeExpanderImpl((JTree)this.getTree()), (JComponent)this.getTree()));
        actions.add(CommonActionsManager.getInstance().createCollapseAllAction((TreeExpander)new TreeExpanderImpl((JTree)this.getTree()), (JComponent)this.getTree()));
        actions.addSeparator();
        actions.add((AnAction)new TableSourceAction((JTable)this.getTreeTableView()));
        return actions;
    }
}

