/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.lobobrowser.util.TimedEntry;

public class History
implements Serializable {
    private static final long serialVersionUID = 2257845000800300100L;
    private transient ArrayList<String> historySequence;
    private final SortedSet<String> historySortedSet = new TreeSet<String>();
    private final Map<String, TimedEntry> historyMap = new HashMap<String, TimedEntry>();
    private final SortedSet<TimedEntry> historyTimedSet = new TreeSet<TimedEntry>();
    private int sequenceCapacity;
    private int commonEntriesCapacity;
    private transient int sequenceIndex = -1;

    public History(int sequenceCapacity, int commonEntriesCapacity) {
        this.historySequence = new ArrayList();
        this.sequenceCapacity = sequenceCapacity;
        this.commonEntriesCapacity = commonEntriesCapacity;
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        this.historySequence = new ArrayList();
        this.sequenceIndex = -1;
        in.defaultReadObject();
    }

    public int getCommonEntriesCapacity() {
        return this.commonEntriesCapacity;
    }

    public void setCommonEntriesCapacity(int commonEntriesCapacity) {
        this.commonEntriesCapacity = commonEntriesCapacity;
    }

    public int getSequenceCapacity() {
        return this.sequenceCapacity;
    }

    public void setSequenceCapacity(int sequenceCapacity) {
        this.sequenceCapacity = sequenceCapacity;
    }

    public String getCurrentItem() {
        if (this.sequenceIndex >= 0) {
            return this.historySequence.get(this.sequenceIndex);
        }
        return null;
    }

    public String back() {
        if (this.sequenceIndex > 0) {
            --this.sequenceIndex;
            return this.getCurrentItem();
        }
        return null;
    }

    public String forward() {
        if (this.sequenceIndex + 1 < this.historySequence.size()) {
            ++this.sequenceIndex;
            return this.getCurrentItem();
        }
        return null;
    }

    public Collection<String> getRecentItems(int maxNumItems) {
        LinkedList<String> items = new LinkedList<String>();
        Iterator i = this.historyTimedSet.iterator();
        int count = 0;
        while (i.hasNext() && count++ < maxNumItems) {
            TimedEntry entry = (TimedEntry)i.next();
            items.add(entry.value);
        }
        return items;
    }

    public Collection<String> getHeadMatchItems(String item, int maxNumItems) {
        String potentialItem;
        Object[] array = this.historySortedSet.toArray();
        int idx = Arrays.binarySearch(array, item);
        int startIdx = idx >= 0 ? idx : -idx - 1;
        int count = 0;
        LinkedList<String> items = new LinkedList<String>();
        for (int i = startIdx; i < array.length && count++ < maxNumItems && (potentialItem = (String)array[i]).startsWith(item); ++i) {
            items.add(potentialItem);
        }
        return items;
    }

    public void addAsRecentOnly(String item) {
        TimedEntry entry = this.historyMap.get(item);
        if (entry != null) {
            this.historyTimedSet.remove(entry);
            entry.touch();
            this.historyTimedSet.add(entry);
        } else {
            entry = new TimedEntry(item);
            this.historyTimedSet.add(entry);
            this.historyMap.put(item, entry);
            this.historySortedSet.add(item);
            if (this.historyTimedSet.size() > this.commonEntriesCapacity) {
                TimedEntry entryToRemove = this.historyTimedSet.last();
                this.historyMap.remove(entryToRemove.value);
                this.historySortedSet.remove(entryToRemove.value);
                this.historyTimedSet.remove(entryToRemove);
            }
        }
    }

    public void addItem(String item, boolean updateAsRecent) {
        int newIndex = this.sequenceIndex + 1;
        while (newIndex >= this.historySequence.size()) {
            this.historySequence.add(null);
        }
        this.historySequence.set(newIndex, item);
        this.sequenceIndex = newIndex;
        int expectedSize = newIndex + 1;
        while (this.historySequence.size() > expectedSize) {
            this.historySequence.remove(expectedSize);
        }
        while (this.historySequence.size() > this.sequenceCapacity) {
            this.historySequence.remove(0);
            --this.sequenceIndex;
        }
        if (updateAsRecent) {
            this.addAsRecentOnly(item);
        }
    }
}

