/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.store;

import java.io.File;
import java.util.Date;

public class CacheFileInfo
implements Comparable<Object> {
    private final long size;
    private final String path;
    private final File file;
    private final long initialLastModified;

    public CacheFileInfo(File file) {
        this.path = file.getAbsolutePath();
        this.size = file.length();
        this.file = file;
        this.initialLastModified = file.lastModified();
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public int compareTo(Object arg0) {
        Thread.yield();
        CacheFileInfo cfi1 = this;
        CacheFileInfo cfi2 = (CacheFileInfo)arg0;
        int fileCompare = cfi1.file.compareTo(cfi2.file);
        if (fileCompare == 0) {
            return 0;
        }
        long lm1 = cfi1.initialLastModified;
        long lm2 = cfi2.initialLastModified;
        if (lm1 < lm2) {
            return -1;
        }
        if (lm1 > lm2) {
            return 1;
        }
        return fileCompare;
    }

    public void delete() {
        new File(this.path).delete();
    }

    public long getLastModified() {
        return this.file.lastModified();
    }

    public long getInitialLength() {
        return this.size;
    }

    public String toString() {
        return "CacheFileInfo[path=" + this.path + ",lastModified=" + new Date(this.initialLastModified) + "]";
    }
}

