/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.settings;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lobobrowser.security.GenericLocalPermission;
import org.lobobrowser.store.StorageManager;

class CookieSettings
implements Serializable {
    private static final Logger logger = Logger.getLogger(CookieSettings.class.getName());
    private static final CookieSettings instance;
    private static final long serialVersionUID = 22574500005000503L;

    private CookieSettings() {
    }

    public static CookieSettings getInstance() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GenericLocalPermission.EXT_GENERIC);
        }
        return instance;
    }

    static {
        CookieSettings ins = null;
        try {
            ins = (CookieSettings)StorageManager.getInstance().retrieveSettings(CookieSettings.class.getSimpleName(), CookieSettings.class.getClassLoader());
        }
        catch (Exception err) {
            logger.log(Level.WARNING, "getInstance(): Unable to retrieve settings.", err);
        }
        if (ins == null) {
            ins = new CookieSettings();
        }
        instance = ins;
    }
}

