/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.settings;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lobobrowser.security.GenericLocalPermission;
import org.lobobrowser.store.StorageManager;
import org.lobobrowser.util.io.NetRoutines;

public class ConnectionSettings
implements Serializable {
    private static final Logger logger = Logger.getLogger(ConnectionSettings.class.getName());
    private static final ConnectionSettings instance;
    private static final long serialVersionUID = 22574500000000301L;
    private Proxy.Type proxyType = Proxy.Type.DIRECT;
    private InetSocketAddress socketAddress = null;
    private String userName;
    private String password;
    private boolean authenticated;
    private boolean disableProxyForLocalAddresses;
    private transient Proxy proxy;

    private ConnectionSettings() {
        this.restoreDefaults();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreDefaults() {
        this.proxyType = Proxy.Type.DIRECT;
        this.userName = "";
        this.password = "";
        this.authenticated = false;
        this.socketAddress = null;
        this.disableProxyForLocalAddresses = true;
        ConnectionSettings connectionSettings = this;
        synchronized (connectionSettings) {
            this.proxy = null;
        }
    }

    public static ConnectionSettings getInstance() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GenericLocalPermission.EXT_GENERIC);
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Proxy getProxy(String host) {
        ConnectionSettings connectionSettings = this;
        synchronized (connectionSettings) {
            Proxy proxy;
            if (this.proxy == null) {
                InetSocketAddress sa = this.socketAddress;
                this.proxy = this.proxyType == Proxy.Type.DIRECT || sa == null ? Proxy.NO_PROXY : new Proxy(this.proxyType, sa);
            }
            if ((proxy = this.proxy) != Proxy.NO_PROXY && this.disableProxyForLocalAddresses && NetRoutines.isLocalAddress(host)) {
                proxy = Proxy.NO_PROXY;
            }
            return proxy;
        }
    }

    public PasswordAuthentication getPasswordAuthentication() {
        String userName = this.userName;
        String password = this.password;
        if (!this.isAuthenticated() || userName == null || password == null) {
            return null;
        }
        return new PasswordAuthentication(userName, password.toCharArray());
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAuthenticated(boolean authenticated) {
        this.authenticated = authenticated;
        ConnectionSettings connectionSettings = this;
        synchronized (connectionSettings) {
            this.proxy = null;
        }
    }

    public String getPassword() {
        return this.password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPassword(String password) {
        this.password = password;
        ConnectionSettings connectionSettings = this;
        synchronized (connectionSettings) {
            this.proxy = null;
        }
    }

    public String getUserName() {
        return this.userName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserName(String userName) {
        this.userName = userName;
        ConnectionSettings connectionSettings = this;
        synchronized (connectionSettings) {
            this.proxy = null;
        }
    }

    public Proxy.Type getProxyType() {
        return this.proxyType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProxyType(Proxy.Type proxyType) {
        this.proxyType = proxyType;
        ConnectionSettings connectionSettings = this;
        synchronized (connectionSettings) {
            this.proxy = null;
        }
    }

    public InetSocketAddress getInetSocketAddress() {
        return this.socketAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInetSocketAddress(InetSocketAddress socketAddress) {
        this.socketAddress = socketAddress;
        ConnectionSettings connectionSettings = this;
        synchronized (connectionSettings) {
            this.proxy = null;
        }
    }

    public boolean isDisableProxyForLocalAddresses() {
        return this.disableProxyForLocalAddresses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDisableProxyForLocalAddresses(boolean disableProxyForLocalAddresses) {
        this.disableProxyForLocalAddresses = disableProxyForLocalAddresses;
        ConnectionSettings connectionSettings = this;
        synchronized (connectionSettings) {
            this.proxy = null;
        }
    }

    public void save() {
        try {
            StorageManager.getInstance().saveSettings(this.getClass().getSimpleName(), this);
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, "save(): Unable to save settings", ioe);
        }
    }

    static {
        ConnectionSettings ins = null;
        try {
            ins = (ConnectionSettings)StorageManager.getInstance().retrieveSettings(ConnectionSettings.class.getSimpleName(), ConnectionSettings.class.getClassLoader());
        }
        catch (Exception err) {
            logger.log(Level.WARNING, "getInstance(): Unable to retrieve settings.", err);
        }
        if (ins == null) {
            ins = new ConnectionSettings();
        }
        instance = ins;
    }
}

