/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.settings;

import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lobobrowser.security.GenericLocalPermission;
import org.lobobrowser.store.StorageManager;
import org.lobobrowser.util.LRUCache;

public class AssociatedSettings
implements Serializable {
    private static final Logger logger = Logger.getLogger(AssociatedSettings.class.getName());
    private static final AssociatedSettings instance;
    private static final long serialVersionUID = 22574500005000804L;
    private final LRUCache userNameByHost = new LRUCache(500);

    private AssociatedSettings() {
    }

    public static AssociatedSettings getInstance() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GenericLocalPermission.EXT_GENERIC);
        }
        return instance;
    }

    public void save() {
        try {
            StorageManager.getInstance().saveSettings(this.getClass().getSimpleName(), this);
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, "Unable to save settings: " + this.getClass().getSimpleName(), ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUserNameForHost(String hostName) {
        AssociatedSettings associatedSettings = this;
        synchronized (associatedSettings) {
            return (String)this.userNameByHost.get(hostName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserNameForHost(String hostName, String userName) {
        AssociatedSettings associatedSettings = this;
        synchronized (associatedSettings) {
            this.userNameByHost.put(hostName, userName, 1);
        }
    }

    static {
        AssociatedSettings ins = null;
        try {
            ins = (AssociatedSettings)StorageManager.getInstance().retrieveSettings(AssociatedSettings.class.getSimpleName(), AssociatedSettings.class.getClassLoader());
        }
        catch (Exception err) {
            logger.log(Level.WARNING, "Unable to retrieve settings.", err);
        }
        if (ins == null) {
            ins = new AssociatedSettings();
        }
        instance = ins;
    }
}

