/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.request;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import org.lobobrowser.async.AsyncResult;
import org.lobobrowser.async.AsyncResultImpl;
import org.lobobrowser.clientlet.CancelClientletException;
import org.lobobrowser.clientlet.ClientletException;
import org.lobobrowser.clientlet.ClientletRequest;
import org.lobobrowser.clientlet.ClientletResponse;
import org.lobobrowser.http.Header;
import org.lobobrowser.http.SSLCertificate;
import org.lobobrowser.main.ExtensionManager;
import org.lobobrowser.request.CacheInfo;
import org.lobobrowser.request.ClientletResponseImpl;
import org.lobobrowser.request.Cookie;
import org.lobobrowser.request.CookieStore;
import org.lobobrowser.request.MemoryCacheEntry;
import org.lobobrowser.request.MultipartFormDataWriter;
import org.lobobrowser.request.RedirectRequestHandler;
import org.lobobrowser.request.RequestHandler;
import org.lobobrowser.request.SimpleRequestHandler;
import org.lobobrowser.settings.BooleanSettings;
import org.lobobrowser.settings.CacheSettings;
import org.lobobrowser.settings.ConnectionSettings;
import org.lobobrowser.store.CacheManager;
import org.lobobrowser.ua.Parameter;
import org.lobobrowser.ua.ParameterInfo;
import org.lobobrowser.ua.ProgressType;
import org.lobobrowser.ua.RequestType;
import org.lobobrowser.ua.UserAgent;
import org.lobobrowser.util.BoxedObject;
import org.lobobrowser.util.ID;
import org.lobobrowser.util.NameValuePair;
import org.lobobrowser.util.SimpleThreadPool;
import org.lobobrowser.util.SimpleThreadPoolTask;
import org.lobobrowser.util.Strings;
import org.lobobrowser.util.Urls;
import org.lobobrowser.util.io.Files;
import org.lobobrowser.util.io.IORoutines;

public final class RequestEngine {
    private static final Logger logger = Logger.getLogger(RequestEngine.class.getName());
    private static final boolean loggerInfo = logger.isLoggable(Level.INFO);
    private final SimpleThreadPool threadPool;
    private final Collection<RequestInfo> processingRequests = new HashSet<RequestInfo>();
    private final CookieStore cookieStore = CookieStore.getInstance();
    private final CacheSettings cacheSettings;
    private final BooleanSettings booleanSettings;
    private final ConnectionSettings connectionSettings;
    private static final RequestEngine instance = new RequestEngine();
    private static final String NORMAL_FORM_ENCODING = "application/x-www-form-urlencoded";

    private RequestEngine() {
        this.threadPool = new SimpleThreadPool("RequestEngineThreadPool", 3, 5, 60000);
        this.cacheSettings = CacheSettings.getInstance();
        this.connectionSettings = ConnectionSettings.getInstance();
        this.booleanSettings = BooleanSettings.getInstance();
    }

    public static RequestEngine getInstance() {
        return instance;
    }

    public String getCookie(URL url) {
        Collection<Cookie> cookies = this.cookieStore.getCookies(url.getHost(), url.getPath());
        StringBuffer cookieText = new StringBuffer();
        for (Cookie cookie : cookies) {
            cookieText.append(cookie.getName());
            cookieText.append('=');
            cookieText.append(cookie.getValue());
            cookieText.append(';');
        }
        return cookieText.toString();
    }

    public void setCookie(URL url, String cookieSpec) {
        this.cookieStore.saveCookie(url, cookieSpec);
    }

    public void setCookie(String urlHostName, String cookieSpec) {
        this.cookieStore.saveCookie(urlHostName, cookieSpec);
    }

    public void cancelAllRequests() {
        this.threadPool.cancelAll();
    }

    public void cancelRequest(RequestHandler rhToDelete) {
        this.threadPool.cancel(new RequestHandlerTask(rhToDelete));
        this.cancelRequestIfRunning(rhToDelete);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelRequestIfRunning(RequestHandler rhToDelete) {
        rhToDelete.cancel();
        ArrayList<RequestInfo> handlersToCancel = new ArrayList<RequestInfo>();
        Collection<RequestInfo> collection = this.processingRequests;
        synchronized (collection) {
            for (RequestInfo rinfo : this.processingRequests) {
                if (rinfo.getRequestHandler() != rhToDelete) continue;
                handlersToCancel.add(rinfo);
            }
        }
        for (RequestInfo rinfo : handlersToCancel) {
            rinfo.abort();
        }
    }

    public void scheduleRequest(RequestHandler handler) {
        SecurityManager sm = System.getSecurityManager();
        AccessControlContext context = sm == null ? null : AccessController.getContext();
        this.threadPool.schedule(new RequestHandlerTask(handler, context));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postData(URLConnection connection, ParameterInfo pinfo, String altPostData) throws IOException {
        BooleanSettings boolSettings = this.booleanSettings;
        String encoding = pinfo.getEncoding();
        if (encoding == null || NORMAL_FORM_ENCODING.equalsIgnoreCase(encoding)) {
            ByteArrayOutputStream bufOut = new ByteArrayOutputStream();
            Parameter[] parameters = pinfo.getParameters();
            boolean firstParam = true;
            for (int i = 0; i < parameters.length; ++i) {
                Parameter parameter = parameters[i];
                String name = parameter.getName();
                String encName = URLEncoder.encode(name, "UTF-8");
                if (parameter.isText()) {
                    if (firstParam) {
                        firstParam = false;
                    } else {
                        bufOut.write(38);
                    }
                    String valueStr = parameter.getTextValue();
                    String encValue = URLEncoder.encode(valueStr, "UTF-8");
                    bufOut.write(encName.getBytes("UTF-8"));
                    bufOut.write(61);
                    bufOut.write(encValue.getBytes("UTF-8"));
                    continue;
                }
                logger.warning("postData(): Ignoring non-textual parameter " + name + " for POST with encoding " + encoding + ".");
            }
            byte[] postContent = bufOut.toByteArray();
            if (loggerInfo) {
                logger.info("postData(): Will post: " + new String(postContent));
            }
            if (connection instanceof HttpURLConnection) {
                if (boolSettings.isHttpUseChunkedEncodingPOST()) {
                    ((HttpURLConnection)connection).setChunkedStreamingMode(8192);
                } else {
                    ((HttpURLConnection)connection).setFixedLengthStreamingMode(postContent.length);
                }
            }
            connection.setRequestProperty("Content-Type", NORMAL_FORM_ENCODING);
            OutputStream postOut = connection.getOutputStream();
            postOut.write(postContent);
            postOut.flush();
        } else if ("multipart/form-data".equalsIgnoreCase(encoding)) {
            OutputStream mfstream;
            boolean chunked;
            String boundary;
            block26: {
                long id = ID.generateLong();
                boundary = "----------------" + id;
                chunked = boolSettings.isHttpUseChunkedEncodingPOST();
                mfstream = chunked ? connection.getOutputStream() : new ByteArrayOutputStream();
                MultipartFormDataWriter writer = new MultipartFormDataWriter(mfstream, boundary);
                try {
                    if (pinfo == null) break block26;
                    Parameter[] parameters = pinfo.getParameters();
                    for (int i = 0; i < parameters.length; ++i) {
                        Parameter parameter = parameters[i];
                        String name = parameter.getName();
                        if (parameter.isText()) {
                            writer.writeText(name, parameter.getTextValue(), "UTF-8");
                            continue;
                        }
                        if (parameter.isFile()) {
                            File[] file = parameter.getFileValue();
                            for (int f = 0; f < file.length; ++f) {
                                FileInputStream in = new FileInputStream(file[f]);
                                try {
                                    BufferedInputStream bin = new BufferedInputStream(in, 8192);
                                    writer.writeFileData(name, file[f].getName(), Files.getContentType(file[f]), bin);
                                    continue;
                                }
                                finally {
                                    in.close();
                                }
                            }
                            continue;
                        }
                        logger.warning("postData(): Skipping parameter " + name + " of unknown type for POST with encoding " + encoding + ".");
                    }
                }
                finally {
                    writer.send();
                }
            }
            connection.addRequestProperty("Content-Type", encoding + "; boundary=" + boundary);
            if (chunked) {
                if (connection instanceof HttpURLConnection) {
                    ((HttpURLConnection)connection).setChunkedStreamingMode(8192);
                }
            } else {
                byte[] content = ((ByteArrayOutputStream)mfstream).toByteArray();
                if (connection instanceof HttpURLConnection) {
                    ((HttpURLConnection)connection).setFixedLengthStreamingMode(content.length);
                }
                OutputStream out = connection.getOutputStream();
                out.write(content);
            }
        } else {
            throw new IllegalArgumentException("Unknown encoding: " + encoding);
        }
    }

    private String completeGetUrl(String baseURL, ParameterInfo pinfo, String ref) throws Exception {
        String newNoRefURL;
        Parameter[] parameters = pinfo.getParameters();
        if (parameters != null && parameters.length > 0) {
            StringBuffer sb = new StringBuffer(baseURL);
            int qmIdx = baseURL.indexOf(63);
            int separator = qmIdx == -1 ? 63 : 38;
            for (int i = 0; i < parameters.length; ++i) {
                if (parameters[i].isText()) {
                    sb.append((char)separator);
                    sb.append(parameters[i].getName());
                    sb.append('=');
                    String paramText = parameters[i].getTextValue();
                    sb.append(URLEncoder.encode(paramText, "UTF-8"));
                    separator = 38;
                    continue;
                }
                logger.warning("completeGetUrl(): Skipping non-textual parameter " + parameters[i].getName() + " in GET request.");
            }
            newNoRefURL = sb.toString();
        } else {
            newNoRefURL = baseURL;
        }
        if (ref != null && ref.length() != 0) {
            return newNoRefURL + "#" + ref;
        }
        return newNoRefURL;
    }

    private void addRequestProperties(URLConnection connection, ClientletRequest request, CacheInfo cacheInfo, String requestMethod, URL lastRequestURL) throws ProtocolException {
        Header[] headers;
        String date;
        UserAgent userAgent = request.getUserAgent();
        connection.addRequestProperty("User-Agent", userAgent.toString());
        connection.addRequestProperty("X-Java-Version", userAgent.getJavaVersion());
        String referrer = request.getReferrer();
        if (referrer != null) {
            connection.addRequestProperty("Referer", referrer);
        }
        if (cacheInfo != null && (date = cacheInfo.getDateAsText()) != null) {
            connection.addRequestProperty("If-Modified-Since", date);
        }
        if (connection instanceof HttpURLConnection) {
            HttpURLConnection hconnection = (HttpURLConnection)connection;
            hconnection.setRequestMethod(requestMethod);
        }
        if ((headers = request.getExtraHeaders()) != null) {
            for (int i = 0; i < headers.length; ++i) {
                String headerName = headers[i].getName();
                if (headerName.startsWith("X-")) {
                    connection.addRequestProperty(headerName, headers[i].getValue());
                    continue;
                }
                logger.warning("run(): Ignoring request header: " + headerName);
            }
        }
    }

    private CacheInfo getCacheInfo(RequestHandler rhandler, final URL url) throws Exception {
        return AccessController.doPrivileged(new PrivilegedAction<CacheInfo>(){

            @Override
            public CacheInfo run() {
                byte[] persistentContent = null;
                CacheManager cm = CacheManager.getInstance();
                MemoryCacheEntry entry = (MemoryCacheEntry)cm.getTransient(url);
                if (!(entry != null || "file".equalsIgnoreCase(url.getProtocol()) && Strings.isBlank(url.getHost()))) {
                    try {
                        persistentContent = cm.getPersistent(url, false);
                    }
                    catch (IOException ioe) {
                        logger.log(Level.WARNING, "getCacheInfo(): Unable to load cache file.", ioe);
                    }
                }
                if (persistentContent == null && entry == null) {
                    return null;
                }
                CacheInfo cinfo = new CacheInfo(entry, persistentContent, url);
                return cinfo;
            }
        });
    }

    private void cache(RequestHandler rhandler, final URL url, final URLConnection connection, final byte[] content, final Serializable altPersistentObject, final Object altObject, final int approxAltObjectSize) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() {
                try {
                    long currentTime = System.currentTimeMillis();
                    if (loggerInfo) {
                        logger.info("cache(): url=" + url + ",content.length=" + content.length + ",currentTime=" + currentTime);
                    }
                    int actualApproxObjectSize = 0;
                    if (altObject != null) {
                        actualApproxObjectSize = approxAltObjectSize < content.length ? content.length : approxAltObjectSize;
                    }
                    Long expiration = Urls.getExpiration(connection, currentTime);
                    List<NameValuePair> headers = Urls.getHeaders(connection);
                    MemoryCacheEntry memEntry = new MemoryCacheEntry(content, headers, expiration, altObject, actualApproxObjectSize);
                    int approxMemEntrySize = content.length + (altObject == null ? 0 : approxAltObjectSize);
                    CacheManager cm = CacheManager.getInstance();
                    cm.putTransient(url, memEntry, approxMemEntrySize);
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    try {
                        boolean hadDate = false;
                        boolean hadContentLength = false;
                        int counter = 0;
                        while (true) {
                            String headerValue;
                            String headerKey;
                            if ((headerKey = connection.getHeaderFieldKey(counter)) != null) {
                                if (!hadDate && "date".equalsIgnoreCase(headerKey)) {
                                    hadDate = true;
                                }
                                if (!hadContentLength && "content-length".equalsIgnoreCase(headerKey)) {
                                    hadContentLength = true;
                                }
                            }
                            if ((headerValue = connection.getHeaderField(counter)) == null) break;
                            if (!"X-Request-Time".equalsIgnoreCase(headerKey)) {
                                String headerPrefix = headerKey == null || headerKey.length() == 0 ? "" : headerKey + ": ";
                                byte[] headerBytes = (headerPrefix + headerValue + "\r\n").getBytes("ISO-8859-1");
                                out.write(headerBytes);
                            }
                            ++counter;
                        }
                        if (!hadDate) {
                            String currentDate = Urls.PATTERN_RFC1123.format(new Date());
                            byte[] headerBytes = ("Date: " + currentDate + "\r\n").getBytes("ISO-8859-1");
                            out.write(headerBytes);
                        }
                        if (!hadContentLength) {
                            byte[] headerBytes = ("Content-Length: " + content.length + "\r\n").getBytes("ISO-8859-1");
                            out.write(headerBytes);
                        }
                        byte[] rtHeaderBytes = ("X-Request-Time: " + currentTime + "\r\n").getBytes("ISO-8859-1");
                        out.write(rtHeaderBytes);
                        out.write(IORoutines.LINE_BREAK_BYTES);
                        out.write(content);
                    }
                    finally {
                        out.close();
                    }
                    try {
                        cm.putPersistent(url, out.toByteArray(), false);
                    }
                    catch (Exception err) {
                        logger.log(Level.WARNING, "cache(): Unable to cache response content.", err);
                    }
                    if (altPersistentObject != null) {
                        try {
                            ByteArrayOutputStream fileOut = new ByteArrayOutputStream();
                            ObjectOutputStream objOut = new ObjectOutputStream(fileOut);
                            objOut.writeObject(altPersistentObject);
                            objOut.flush();
                            byte[] byteArray = fileOut.toByteArray();
                            if (byteArray.length == 0) {
                                logger.log(Level.WARNING, "cache(): Serialized content has zero bytes for persistent object " + altPersistentObject + ".");
                            }
                            cm.putPersistent(url, byteArray, true);
                        }
                        catch (Exception err) {
                            logger.log(Level.WARNING, "cache(): Unable to write persistent cached object.", err);
                        }
                    }
                }
                catch (Exception err) {
                    logger.log(Level.WARNING, "cache()", err);
                }
                return null;
            }
        });
    }

    private boolean mayBeCached(HttpURLConnection connection) {
        String cacheControl = connection.getHeaderField("Cache-Control");
        if (cacheControl != null) {
            StringTokenizer tok = new StringTokenizer(cacheControl, ",");
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken().trim();
                if (!"no-cache".equalsIgnoreCase(token)) continue;
                return false;
            }
        }
        return true;
    }

    private void printRequestHeaders(URLConnection connection) {
        Map<String, List<String>> headers = connection.getRequestProperties();
        StringBuffer buffer = new StringBuffer();
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            buffer.append(entry.getKey() + ": " + entry.getValue());
            buffer.append(System.getProperty("line.separator"));
        }
        logger.info("printRequestHeaders(): Request headers for URI=[" + connection.getURL() + "]\r\n" + buffer.toString());
    }

    public void inlineRequest(RequestHandler rhandler) {
        this.processHandler(rhandler, 0, false);
    }

    public byte[] loadBytes(String urlOrPath) throws Exception {
        return this.loadBytes(Urls.guessURL(urlOrPath));
    }

    public byte[] loadBytes(URL url) throws Exception {
        final BoxedObject boxed = new BoxedObject();
        this.inlineRequest(new SimpleRequestHandler(url, RequestType.ELEMENT){

            @Override
            public boolean handleException(ClientletResponse response, Throwable exception) throws ClientletException {
                if (exception instanceof ClientletException) {
                    throw (ClientletException)exception;
                }
                throw new ClientletException(exception);
            }

            @Override
            public void processResponse(ClientletResponse response) throws ClientletException, IOException {
                byte[] bytes = IORoutines.load(response.getInputStream(), 4096);
                boxed.setObject(bytes);
            }
        });
        return (byte[])boxed.getObject();
    }

    public AsyncResult<byte[]> loadBytesAsync(String urlOrPath) throws MalformedURLException {
        return this.loadBytesAsync(Urls.guessURL(urlOrPath));
    }

    public AsyncResult<byte[]> loadBytesAsync(URL url) {
        final AsyncResultImpl<byte[]> asyncResult = new AsyncResultImpl<byte[]>();
        this.scheduleRequest(new SimpleRequestHandler(url, RequestType.ELEMENT){

            @Override
            public boolean handleException(ClientletResponse response, Throwable exception) throws ClientletException {
                asyncResult.setException(exception);
                return true;
            }

            @Override
            public void processResponse(ClientletResponse response) throws ClientletException, IOException {
                byte[] bytes = IORoutines.load(response.getInputStream(), 4096);
                asyncResult.setResult(bytes);
            }
        });
        return asyncResult;
    }

    private static boolean shouldRevalidateAlways(URL connectionUrl, RequestType requestType) {
        return requestType == RequestType.ADDRESS_BAR;
    }

    private static boolean doesNotExpire(RequestType requestType) {
        return requestType == RequestType.HISTORY;
    }

    private ExtensionManager getSafeExtensionManager() {
        return AccessController.doPrivileged(new PrivilegedAction<ExtensionManager>(){

            @Override
            public ExtensionManager run() {
                return ExtensionManager.getInstance();
            }
        });
    }

    private URLConnection getURLConnection(URL connectionUrl, ClientletRequest request, String protocol, String method, RequestHandler rhandler, CacheInfo cacheInfo) throws IOException {
        Proxy proxy;
        if (cacheInfo != null) {
            RequestType requestType = rhandler.getRequestType();
            if (RequestEngine.doesNotExpire(requestType)) {
                if (loggerInfo) {
                    if (cacheInfo.hasTransientEntry()) {
                        logger.info("getURLConnection(): FROM-RAM: " + connectionUrl + ".");
                    } else {
                        logger.info("getURLConnection(): FROM-FILE: " + connectionUrl + ".");
                    }
                }
                return cacheInfo.getURLConnection();
            }
            if (!RequestEngine.shouldRevalidateAlways(connectionUrl, requestType)) {
                Integer defaultOffset;
                Long expires = cacheInfo.getExpires();
                if (expires == null && (defaultOffset = Integer.valueOf(this.cacheSettings.getDefaultCacheExpirationOffset())) != null) {
                    expires = cacheInfo.getExpiresGivenOffset(defaultOffset.longValue());
                    if (loggerInfo) {
                        Date expiresDate = expires == null ? null : new Date(expires);
                        logger.info("getURLConnection(): Used default offset for " + connectionUrl + ": expires=" + expiresDate);
                    }
                }
                if (expires != null) {
                    if (expires > System.currentTimeMillis()) {
                        if (loggerInfo) {
                            long secondsToExpiration = (expires - System.currentTimeMillis()) / 1000L;
                            if (cacheInfo.hasTransientEntry()) {
                                logger.info("getURLConnection(): FROM-RAM: " + connectionUrl + ". Expires in " + secondsToExpiration + " seconds.");
                            } else {
                                logger.info("getURLConnection(): FROM-FILE: " + connectionUrl + ". Expires in " + secondsToExpiration + " seconds.");
                            }
                        }
                        return cacheInfo.getURLConnection();
                    }
                    if (loggerInfo) {
                        logger.info("getURLConnection(): EXPIRED: " + connectionUrl + ". Expired on " + new Date(expires) + ".");
                    }
                }
            }
        }
        boolean isPost = "POST".equalsIgnoreCase(method);
        String host = connectionUrl.getHost();
        boolean isResURL = "res".equalsIgnoreCase(protocol);
        SSLCertificate.setCertificate();
        URLConnection connection = isResURL || host == null || host.length() == 0 ? connectionUrl.openConnection() : ((proxy = this.connectionSettings.getProxy(host)) == Proxy.NO_PROXY ? connectionUrl.openConnection() : connectionUrl.openConnection(proxy));
        if (connection instanceof HttpsURLConnection) {
            ((HttpsURLConnection)connection).setHostnameVerifier(rhandler.getHostnameVerifier());
        }
        if (isPost) {
            connection.setDoOutput(true);
        }
        connection.setUseCaches(false);
        if (connection instanceof HttpURLConnection) {
            HttpURLConnection hconnection = (HttpURLConnection)connection;
            hconnection.setConnectTimeout(60000);
            hconnection.setReadTimeout(90000);
        }
        this.addRequestProperties(connection, request, cacheInfo, method, connectionUrl);
        connection = this.getSafeExtensionManager().dispatchPreConnection(connection);
        if (logger.isLoggable(Level.FINE)) {
            this.printRequestHeaders(connection);
        }
        if (isPost) {
            ParameterInfo pinfo;
            ParameterInfo parameterInfo = pinfo = rhandler instanceof RedirectRequestHandler ? null : request.getParameterInfo();
            if (pinfo == null) {
                throw new IllegalStateException("POST has no parameter information");
            }
            this.postData(connection, pinfo, request.getAltPostData());
        }
        return connection;
    }

    private static boolean isOKToRetrieveFromCache(RequestType requestType) {
        return requestType != RequestType.SOFT_RELOAD && requestType != RequestType.HARD_RELOAD && requestType != RequestType.DOWNLOAD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processHandler(RequestHandler rhandler, int recursionLevel, boolean trackRequestInfo) {
        boolean linfo = loggerInfo;
        URL baseURL = rhandler.getLatestRequestURL();
        RequestInfo rinfo = null;
        ClientletResponseImpl response = null;
        String method = null;
        try {
            URL connectionUrl;
            URL url;
            ClientletRequest request = rhandler.getRequest();
            method = rhandler.getLatestRequestMethod().toUpperCase();
            ParameterInfo pinfo = rhandler instanceof RedirectRequestHandler ? null : request.getParameterInfo();
            boolean isGet = "GET".equals(method);
            if (isGet && pinfo != null) {
                String ref = baseURL.getRef();
                String noRefForm = Urls.getNoRefForm(baseURL);
                String newURLText = this.completeGetUrl(noRefForm, pinfo, ref);
                url = new URL(newURLText);
            } else {
                url = baseURL;
            }
            CacheInfo cacheInfo = null;
            String protocol = url.getProtocol();
            if (url.getQuery() != null && "file".equalsIgnoreCase(protocol)) {
                String ref = url.getRef();
                String refText = ref == null || ref.length() == 0 ? "" : "#" + ref;
                connectionUrl = new URL(protocol, url.getHost(), url.getPort(), url.getPath() + refText);
            } else {
                connectionUrl = url;
            }
            RequestType requestType = rhandler.getRequestType();
            if (isGet && RequestEngine.isOKToRetrieveFromCache(requestType)) {
                cacheInfo = this.getCacheInfo(rhandler, connectionUrl);
            }
            try {
                SSLCertificate.setCertificate();
                URLConnection connection = this.getURLConnection(connectionUrl, request, protocol, method, rhandler, cacheInfo);
                rinfo = new RequestInfo(connection, rhandler);
                InputStream responseIn = null;
                if (trackRequestInfo) {
                    Collection<RequestInfo> collection = this.processingRequests;
                    synchronized (collection) {
                        this.processingRequests.add(rinfo);
                    }
                }
                try {
                    boolean isCacheable;
                    boolean isContentCached;
                    block85: {
                        block87: {
                            int responseCode;
                            HttpURLConnection hconnection;
                            block86: {
                                if (rhandler.isCancelled()) {
                                    throw new CancelClientletException("cancelled");
                                }
                                rhandler.handleProgress(ProgressType.CONNECTING, url, method, 0, -1);
                                isContentCached = cacheInfo != null && cacheInfo.isCacheConnection(connection);
                                isCacheable = false;
                                if (!(connection instanceof HttpsURLConnection) || isContentCached) break block86;
                                hconnection = (HttpsURLConnection)connection;
                                hconnection.setInstanceFollowRedirects(true);
                                responseCode = hconnection.getResponseCode();
                                if (linfo) {
                                    logger.info("run(): ResponseCode=" + responseCode + " for url=" + connectionUrl);
                                }
                                if (responseCode == 200) {
                                    if (linfo) {
                                        logger.info("run(): FROM-HTTP: " + connectionUrl);
                                    }
                                    if (this.mayBeCached(hconnection)) {
                                        isCacheable = true;
                                    } else {
                                        if (linfo) {
                                            logger.info("run(): NOT CACHEABLE: " + connectionUrl);
                                        }
                                        if (cacheInfo != null) {
                                            cacheInfo.delete();
                                        }
                                    }
                                    responseIn = connection.getInputStream();
                                    rinfo.setConnection(connection, responseIn);
                                    break block85;
                                } else if (responseCode == 304) {
                                    if (cacheInfo == null) {
                                        throw new IllegalStateException("Cache info missing but it is necessary to process response code " + responseCode + ".");
                                    }
                                    if (linfo) {
                                        logger.info("run(): FROM-VALIDATION: " + connectionUrl);
                                    }
                                    hconnection.disconnect();
                                    isContentCached = true;
                                    isCacheable = true;
                                    connection = cacheInfo.getURLConnection();
                                    responseIn = connection.getInputStream();
                                    rinfo.setConnection(connection, responseIn);
                                    break block85;
                                } else if (responseCode == 301 || responseCode == 302 || responseCode == 303) {
                                    if (linfo) {
                                        logger.info("run(): REDIRECTING: ResponseCode=" + responseCode + " for url=" + url);
                                    }
                                    RedirectRequestHandler newHandler = new RedirectRequestHandler(rhandler, hconnection);
                                    Thread.yield();
                                    if (recursionLevel > 5) {
                                        throw new ClientletException("Exceeded redirect recursion limit.");
                                    }
                                    this.processHandler(newHandler, recursionLevel + 1, trackRequestInfo);
                                    return;
                                }
                                break block85;
                            }
                            if (!(connection instanceof HttpURLConnection) || isContentCached) break block87;
                            hconnection = (HttpURLConnection)connection;
                            hconnection.setInstanceFollowRedirects(false);
                            responseCode = hconnection.getResponseCode();
                            if (linfo) {
                                logger.info("run(): ResponseCode=" + responseCode + " for url=" + connectionUrl);
                            }
                            if (responseCode == 200) {
                                if (linfo) {
                                    logger.info("run(): FROM-HTTP: " + connectionUrl);
                                }
                                if (this.mayBeCached(hconnection)) {
                                    isCacheable = true;
                                } else {
                                    if (linfo) {
                                        logger.info("run(): NOT CACHEABLE: " + connectionUrl);
                                    }
                                    if (cacheInfo != null) {
                                        cacheInfo.delete();
                                    }
                                }
                                responseIn = connection.getInputStream();
                                rinfo.setConnection(connection, responseIn);
                                break block85;
                            } else if (responseCode == 304) {
                                if (cacheInfo == null) {
                                    throw new IllegalStateException("Cache info missing but it is necessary to process response code " + responseCode + ".");
                                }
                                if (linfo) {
                                    logger.info("run(): FROM-VALIDATION: " + connectionUrl);
                                }
                                hconnection.disconnect();
                                isContentCached = true;
                                isCacheable = true;
                                connection = cacheInfo.getURLConnection();
                                responseIn = connection.getInputStream();
                                rinfo.setConnection(connection, responseIn);
                                break block85;
                            } else if (responseCode == 301 || responseCode == 302 || responseCode == 303) {
                                if (linfo) {
                                    logger.info("run(): REDIRECTING: ResponseCode=" + responseCode + " for url=" + url);
                                }
                                RedirectRequestHandler newHandler = new RedirectRequestHandler(rhandler, hconnection);
                                Thread.yield();
                                if (recursionLevel > 5) {
                                    throw new ClientletException("Exceeded redirect recursion limit.");
                                }
                                this.processHandler(newHandler, recursionLevel + 1, trackRequestInfo);
                                return;
                            }
                            break block85;
                        }
                        responseIn = connection.getInputStream();
                        rinfo.setConnection(connection, responseIn);
                    }
                    if (rinfo.isAborted()) {
                        throw new CancelClientletException("Stopped");
                    }
                    URLConnection newConnection = this.getSafeExtensionManager().dispatchPostConnection(connection);
                    if (newConnection != connection) {
                        responseIn = newConnection.getInputStream();
                        connection = newConnection;
                    }
                    response = new ClientletResponseImpl(rhandler, connection, url, isContentCached, cacheInfo, isCacheable, rhandler.getRequestType());
                    rhandler.processResponse(response);
                    if (isCacheable) {
                        response.ensureReachedEOF();
                        byte[] content = response.getStoredContent();
                        if (content != null) {
                            Serializable persObject = response.getNewPersistentCachedObject();
                            Object altObject = response.getNewTransientCachedObject();
                            int altObjectSize = response.getNewTransientObjectSize();
                            this.cache(rhandler, connectionUrl, connection, content, persObject, altObject, altObjectSize);
                            return;
                        }
                        logger.warning("processHandler(): Cacheable response not available: " + connectionUrl);
                        return;
                    }
                    if (cacheInfo == null) return;
                    if (cacheInfo.hasTransientEntry()) return;
                    final byte[] persContent = cacheInfo.getPersistentContent();
                    Object altObject = response.getNewTransientCachedObject();
                    int altObjectSize = response.getNewTransientObjectSize();
                    final MemoryCacheEntry newMemEntry = new MemoryCacheEntry(persContent, cacheInfo.getExpires(), cacheInfo.getRequestTime(), altObject, altObjectSize);
                    final int actualApproxObjectSize = altObject != null ? (altObjectSize < persContent.length ? persContent.length : altObjectSize) : 0;
                    AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            CacheManager.getInstance().putTransient(connectionUrl, newMemEntry, actualApproxObjectSize + persContent.length);
                            return null;
                        }
                    });
                    return;
                }
                finally {
                    if (trackRequestInfo) {
                        Collection<RequestInfo> collection = this.processingRequests;
                        synchronized (collection) {
                            this.processingRequests.remove(rinfo);
                        }
                    }
                    if (responseIn != null) {
                        try {
                            responseIn.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (connection instanceof HttpURLConnection) {
                        ((HttpURLConnection)connection).disconnect();
                    }
                }
            }
            finally {
                if (cacheInfo != null) {
                    cacheInfo.dispose();
                }
            }
        }
        catch (CancelClientletException cce) {
            if (!linfo) return;
            logger.log(Level.INFO, "run(): Clientlet cancelled: " + baseURL, cce);
            return;
        }
        catch (Throwable exception) {
            if (rinfo != null && rinfo.isAborted()) {
                if (!linfo) return;
                logger.log(Level.INFO, "run(): Exception ignored because request aborted.", exception);
                return;
            }
            try {
                if (rhandler.handleException(response, exception)) return;
                logger.log(Level.WARNING, "Was unable to handle exception.", exception);
                return;
            }
            catch (Exception err) {
                logger.log(Level.WARNING, "Exception handler threw an exception.", err);
                return;
            }
        }
        finally {
            rhandler.handleProgress(ProgressType.DONE, baseURL, method, 0, 0);
        }
    }

    public boolean isFile(String url) {
        for (int i = url.length() - 1; i > 0; --i) {
            if (!url.substring(i).contains(".")) continue;
            return true;
        }
        return false;
    }

    private class RequestHandlerTask
    implements SimpleThreadPoolTask {
        private final RequestHandler handler;
        private final AccessControlContext accessContext;

        private RequestHandlerTask(RequestHandler handler, AccessControlContext accessContext) {
            this.handler = handler;
            this.accessContext = accessContext;
        }

        private RequestHandlerTask(RequestHandler handler) {
            this.handler = handler;
            this.accessContext = null;
        }

        @Override
        public void run() {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null && this.accessContext != null) {
                PrivilegedAction<Object> action = new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        RequestEngine.this.processHandler(RequestHandlerTask.this.handler, 0, true);
                        return null;
                    }
                };
                AccessController.doPrivileged(action, this.accessContext);
            } else {
                RequestEngine.this.processHandler(this.handler, 0, true);
            }
        }

        @Override
        public void cancel() {
            RequestEngine.this.cancelRequestIfRunning(this.handler);
        }

        public int hashCode() {
            return this.handler.hashCode();
        }

        public boolean equals(Object other) {
            return other instanceof RequestHandlerTask && ((RequestHandlerTask)other).handler.equals(this.handler);
        }

        public String toString() {
            return "RequestHandlerTask[host=" + this.handler.getLatestRequestURL().getHost() + "]";
        }
    }

    private static class RequestInfo {
        private final RequestHandler requestHandler;
        private volatile boolean isAborted = false;
        private volatile InputStream inputStream;
        private volatile URLConnection connection;

        RequestInfo(URLConnection connection, RequestHandler rhandler) {
            this.connection = connection;
            this.requestHandler = rhandler;
        }

        boolean isAborted() {
            return this.isAborted;
        }

        void abort() {
            try {
                InputStream in;
                this.isAborted = true;
                if (this.connection instanceof HttpURLConnection) {
                    ((HttpURLConnection)this.connection).disconnect();
                }
                if ((in = this.inputStream) != null) {
                    in.close();
                }
            }
            catch (Exception err) {
                logger.log(Level.SEVERE, "abort()", err);
            }
        }

        RequestHandler getRequestHandler() {
            return this.requestHandler;
        }

        void setConnection(URLConnection connection, InputStream in) {
            this.connection = connection;
            this.inputStream = in;
        }
    }
}

