/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.primary.gui.prefs;

import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.lobobrowser.primary.gui.prefs.AbstractSettingsUI;
import org.lobobrowser.primary.gui.prefs.ConnectionSettingsUI;
import org.lobobrowser.primary.gui.prefs.GeneralSettingsUI;
import org.lobobrowser.primary.gui.prefs.SettingsInfo;
import org.lobobrowser.primary.gui.prefs.ToolsSettingsUI;

public class PreferencesTree
extends JTree {
    private static final long serialVersionUID = 1L;

    public PreferencesTree() {
        TreeNode rootNode = this.createRootNode();
        this.setModel(new DefaultTreeModel(rootNode));
        this.setRootVisible(false);
    }

    public void initSelection() {
        this.addSelectionRow(0);
    }

    private TreeNode createRootNode() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        root.add(new DefaultMutableTreeNode(this.getGeneralSettingsInfo()));
        root.add(new DefaultMutableTreeNode(this.getConnectionSettingsInfo()));
        root.add(new DefaultMutableTreeNode(this.getToolsSettingsInfo()));
        return root;
    }

    private SettingsInfo getGeneralSettingsInfo() {
        return new SettingsInfo(){

            @Override
            public AbstractSettingsUI createSettingsUI() {
                return new GeneralSettingsUI();
            }

            @Override
            public String getDescription() {
                return "General browser settings.";
            }

            @Override
            public String getName() {
                return "General";
            }

            public String toString() {
                return this.getName();
            }
        };
    }

    private SettingsInfo getConnectionSettingsInfo() {
        return new SettingsInfo(){

            @Override
            public AbstractSettingsUI createSettingsUI() {
                return new ConnectionSettingsUI();
            }

            @Override
            public String getDescription() {
                return "Network connection settings.";
            }

            @Override
            public String getName() {
                return "Connection";
            }

            public String toString() {
                return this.getName();
            }
        };
    }

    private SettingsInfo getToolsSettingsInfo() {
        return new SettingsInfo(){

            @Override
            public AbstractSettingsUI createSettingsUI() {
                return new ToolsSettingsUI();
            }

            @Override
            public String getDescription() {
                return "Tools settings.";
            }

            @Override
            public String getName() {
                return "Tools";
            }

            public String toString() {
                return this.getName();
            }
        };
    }
}

