/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.primary.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class SwingTasks {
    private static final String NESTED_ENABLING = "$nested.enabling";

    public static void setNestedEnabled(JComponent component, boolean enabled) {
        Boolean nestedEnabling = (Boolean)component.getClientProperty(NESTED_ENABLING);
        if (nestedEnabling == null || nestedEnabling != enabled) {
            component.putClientProperty(NESTED_ENABLING, enabled);
            Container parent = component.getParent();
            if (parent == null || !enabled || parent.isEnabled()) {
                SwingTasks.setEnabledRecursive(component, enabled);
            }
        }
    }

    private static void setEnabledRecursive(JComponent component, boolean enabled) {
        component.setEnabled(enabled);
        int count = component.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component child = component.getComponent(i);
            if (!(child instanceof JComponent)) continue;
            JComponent jchild = (JComponent)child;
            if (enabled) {
                Boolean nestedEnabling = (Boolean)jchild.getClientProperty(NESTED_ENABLING);
                if (nestedEnabling != null && !nestedEnabling.booleanValue()) continue;
                SwingTasks.setEnabledRecursive(jchild, true);
                continue;
            }
            SwingTasks.setEnabledRecursive(jchild, false);
        }
    }

    public static Component createVerticalFill() {
        Dimension pref;
        Dimension min = new Dimension(0, 0);
        Dimension max = pref = new Dimension(0, Short.MAX_VALUE);
        return new Box.Filler(min, pref, max);
    }

    public static Component createHorizontalFill() {
        Dimension pref;
        Dimension min = new Dimension(0, 0);
        Dimension max = pref = new Dimension(Short.MAX_VALUE, 0);
        return new Box.Filler(min, pref, max);
    }

    public static Frame getFrame(Component component) {
        Container ancestor;
        for (ancestor = component.getParent(); ancestor != null && !(ancestor instanceof Frame); ancestor = ancestor.getParent()) {
        }
        return (Frame)ancestor;
    }

    public static Dialog getDialog(Component component) {
        Container ancestor;
        for (ancestor = component.getParent(); ancestor != null && !(ancestor instanceof Dialog); ancestor = ancestor.getParent()) {
        }
        return (Dialog)ancestor;
    }

    public static Box createGroupBox(int orientation, String title) {
        Box box = new Box(orientation);
        box.setBorder(new TitledBorder(new EtchedBorder(), title));
        return box;
    }
}

