/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.primary.gui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.lobobrowser.primary.action.EditAction;

public class StringListControl
extends JComponent {
    private static final long serialVersionUID = 1L;
    private final JComboBox comboBox;
    private String editListCaption;
    private String[] strings;

    public StringListControl() {
        this.setLayout(new BoxLayout(this, 0));
        this.comboBox = new JComboBox();
        this.comboBox.setEditable(false);
        JButton editButton = new JButton();
        editButton.setAction(new EditAction(this));
        editButton.setText("Edit List");
        this.add(this.comboBox);
        this.add(editButton);
    }

    public void setStrings(String[] strings) {
        this.strings = strings;
        JComboBox comboBox = this.comboBox;
        comboBox.removeAllItems();
        for (String string : strings) {
            comboBox.addItem(string);
        }
    }

    public String[] getStrings() {
        return this.strings;
    }

    public String getStringsAsText() {
        String lineSeparator = System.getProperty("line.separator");
        String[] strings = this.strings;
        if (strings == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        for (String string : strings) {
            buffer.append(string);
            buffer.append(lineSeparator);
        }
        return buffer.toString();
    }

    public void setStringsFromText(String text) {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new StringReader(text));
            ArrayList<String> stringsAL = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                stringsAL.add(line);
            }
            this.setStrings(stringsAL.toArray(new String[0]));
        }
        catch (IOException ioe) {
            throw new IllegalStateException("not expected", ioe);
        }
    }

    public String getEditListCaption() {
        return this.editListCaption;
    }

    public void setEditListCaption(String caption) {
        this.editListCaption = caption;
    }
}

