/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.primary.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import org.lobobrowser.primary.action.TextEditCancelAction;
import org.lobobrowser.primary.action.TextEditOkAction;

public class SimpleTextEditDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final JLabel captionLabel = new JLabel();
    private final JTextArea textArea = new JTextArea();
    private final JButton okButton = new JButton();
    private final JButton cancelButton = new JButton();
    private String resultingText;

    public SimpleTextEditDialog(Frame parent) {
        super(parent);
        this.init();
    }

    public SimpleTextEditDialog(Dialog parent) {
        super(parent);
        this.init();
    }

    public void setCaption(String text) {
        this.captionLabel.setText(text);
    }

    public void setText(String text) {
        this.textArea.setText(text);
    }

    public String getText() {
        return this.textArea.getText();
    }

    private void init() {
        this.captionLabel.setPreferredSize(new Dimension(Short.MAX_VALUE, 32));
        this.captionLabel.setAlignmentX(0.0f);
        this.captionLabel.setBorder(new EmptyBorder(8, 0, 8, 0));
        this.textArea.setPreferredSize(new Dimension(1, Short.MAX_VALUE));
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        contentPane.add(this.captionLabel);
        contentPane.add(new JScrollPane(this.textArea));
        contentPane.add(this.createButtonPanel());
        this.textArea.setEditable(true);
        this.okButton.setAction(new TextEditOkAction(this.textArea, this));
        this.okButton.setText("OK");
        this.cancelButton.setAction(new TextEditCancelAction(this));
        this.cancelButton.setText("Cancel");
    }

    private Component createButtonPanel() {
        Box panel = new Box(0);
        panel.setPreferredSize(new Dimension(Short.MAX_VALUE, 0));
        panel.setBorder(new EmptyBorder(4, 4, 4, 4));
        panel.add(Box.createGlue());
        panel.add(this.okButton);
        panel.add(Box.createRigidArea(new Dimension(4, 1)));
        panel.add(this.cancelButton);
        panel.add(Box.createGlue());
        return panel;
    }

    public String getResultingText() {
        return this.resultingText;
    }

    public String setResultingText(String resultingText) {
        this.resultingText = resultingText;
        return this.resultingText;
    }
}

